/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import org.editorconfig.language.filetype.EditorConfigFileType;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorConfigEditorNotificationProvider
implements EditorNotificationProvider {
    EditorConfigEditorNotificationProvider() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        return file.getFileType().equals((Object)EditorConfigFileType.INSTANCE) && !EditorConfigEditorNotificationProvider.getEditorConfigSettings((Project)project).ENABLED ? fileEditor -> new MyPanel((FileEditor)fileEditor, project) : null;
    }

    @NotNull
    private static EditorConfigSettings getEditorConfigSettings(@NotNull Project project) {
        return (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
    }

    private static final class MyPanel
    extends EditorNotificationPanel {
        private MyPanel(@NotNull FileEditor fileEditor, @NotNull Project project) {
            super(fileEditor, EditorNotificationPanel.Status.Warning);
            this.setText(EditorConfigBundle.message("editor.notification.disabled"));
            this.createActionLabel(EditorConfigBundle.message("editor.notification.enable"), () -> {
                EditorConfigEditorNotificationProvider.getEditorConfigSettings((Project)project).ENABLED = true;
                CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
            });
            this.createActionLabel(EditorConfigBundle.message("editor.notification.open.settings"), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, IdeBundle.message((String)"configurable.CodeStyle.display.name", (Object[])new Object[0])));
        }
    }
}

