/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.create;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.List;
import org.editorconfig.configmanagement.create.CreateEditorConfigDialog;
import org.editorconfig.configmanagement.export.EditorConfigSettingsWriter;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateEditorConfigAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CreateEditorConfigAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        CreateEditorConfigDialog dialog;
        Project project = e.getProject();
        if (project != null && (dialog = new CreateEditorConfigDialog(project)).showAndGet() && (view = this.getIdeView(e)) != null) {
            CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
            PsiDirectory dir = view.getOrChooseDirectory();
            if (dir != null) {
                VirtualFile dirVFile = dir.getVirtualFile();
                File outputFile = CreateEditorConfigAction.getOutputFile(dirVFile);
                if (!outputFile.exists()) {
                    VirtualFile target = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> this.export(dirVFile, outputFile, project, settings, dialog.isRoot(), dialog.isCommentProperties(), dialog.getLanguages(), dialog.getPropertyKinds()));
                    if (target != null) {
                        OpenFileAction.openFile((VirtualFile)target, (Project)project);
                        PsiFile psiFile = CreateEditorConfigAction.getPsiFile(project, target);
                        if (psiFile != null) {
                            view.selectElement((PsiElement)psiFile);
                        }
                    }
                } else {
                    Messages.showErrorDialog((Project)project, (String)EditorConfigBundle.message("notification.message.another.editorconfig.file.already.exists.in.0", dirVFile.getPath()), (String)EditorConfigBundle.message("dialog.title.new.editorconfig.file"));
                }
            }
        }
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null) {
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (PlatformUtils.isRider()) {
            presentation.setVisible(false);
            return;
        }
        IdeView view = this.getIdeView(e);
        if (view != null) {
            presentation.setVisible(e.getProject() != null && CreateEditorConfigAction.isAvailableFor(view.getDirectories()));
        } else {
            presentation.setEnabledAndVisible(false);
        }
        presentation.setIcon(AllIcons.Nodes.Editorconfig);
    }

    private static boolean isAvailableFor(PsiDirectory @NotNull [] dirs) {
        for (PsiDirectory dir : dirs) {
            if (!dir.getVirtualFile().getFileSystem().isReadOnly()) continue;
            return false;
        }
        return dirs.length > 0;
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    private IdeView getIdeView(@NotNull AnActionEvent e) {
        return (IdeView)e.getData(LangDataKeys.IDE_VIEW);
    }

    @NotNull
    private static File getOutputFile(@NotNull VirtualFile dir) {
        return new File(dir.getPath() + File.separator + ".editorconfig");
    }

    @Nullable
    private VirtualFile export(@NotNull VirtualFile outputDir, @NotNull File outputFile, @NotNull Project project, @NotNull CodeStyleSettings settings, boolean isRoot, boolean commentOutProperties, @NotNull List<Language> languages, EditorConfigPropertyKind ... propertyKinds) {
        VirtualFile virtualFile;
        block8: {
            VirtualFile target = outputDir.createChildData((Object)this, outputFile.getName());
            EditorConfigSettingsWriter settingsWriter = new EditorConfigSettingsWriter(project, target.getOutputStream((Object)this), settings, isRoot, commentOutProperties).forLanguages(languages).forPropertyKinds(propertyKinds);
            try {
                settingsWriter.writeSettings();
                virtualFile = target;
                if (settingsWriter == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (settingsWriter != null) {
                        try {
                            settingsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    CreateEditorConfigAction.notifyFailed(e);
                    return null;
                }
            }
            settingsWriter.close();
        }
        return virtualFile;
    }

    private static void notifyFailed(@NotNull Exception e) {
        LOG.warn((Throwable)e);
        Notifications.Bus.notify((Notification)new Notification("editorconfig", EditorConfigBundle.message("notification.title.editorconfig.creation.failed"), e.getMessage(), NotificationType.ERROR));
    }
}

