/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.jetbrains.annotations.NotNull;

public final class EditorConfigUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("editorconfig", 2);
    private static final EventId3<FileType, OptionType, Integer> EDITOR_CONFIG_USED = GROUP.registerEvent("editorconfig.applied", (EventField)EventFields.FileType, (EventField)EventFields.Enum((String)"property", OptionType.class), (EventField)EventFields.Count);

    private EditorConfigUsagesCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logEditorConfigUsed(@NotNull PsiFile file, @NotNull List<EditorConfig.OutPair> options) {
        options.stream().map(pair -> EditorConfigUsagesCollector.getOptionType(pair.getKey())).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((optionType, count) -> EDITOR_CONFIG_USED.log(file.getProject(), (Object)file.getFileType(), (Object)optionType, (Object)count.intValue()));
    }

    private static OptionType getOptionType(@NotNull String optionKey) {
        EditorConfigPropertyKind propertyKind = IntellijPropertyKindMap.getPropertyKind(optionKey);
        if (propertyKind.equals((Object)EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD)) {
            return OptionType.Standard;
        }
        if (optionKey.startsWith("ij_")) {
            return OptionType.IntelliJ;
        }
        return OptionType.Other;
    }

    private static enum OptionType {
        Standard,
        IntelliJ,
        Other;

    }
}

