/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.fileEditor.TrailingSpacesOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.StandardEditorConfigProperties;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigTrailingSpacesOptionsProvider
implements TrailingSpacesOptionsProvider,
StandardEditorConfigProperties {
    @Nullable
    public TrailingSpacesOptionsProvider.Options getOptions(@NotNull Project project, @NotNull VirtualFile file) {
        if (Utils.isEnabled(CodeStyle.getSettings((Project)project))) {
            List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(project, file);
            Boolean trimTrailingWhitespace = EditorConfigTrailingSpacesOptionsProvider.getBooleanValue(outPairs, "trim_trailing_whitespace");
            Boolean insertFinalNewline = EditorConfigTrailingSpacesOptionsProvider.getBooleanValue(outPairs, "insert_final_newline");
            if (trimTrailingWhitespace != null || insertFinalNewline != null) {
                return new FileOptions(trimTrailingWhitespace, insertFinalNewline);
            }
        }
        return null;
    }

    @Nullable
    private static Boolean getBooleanValue(@NotNull List<EditorConfig.OutPair> pairs, @NotNull String key) {
        String rawValue = Utils.configValueForKey(pairs, key);
        if ("false".equalsIgnoreCase(rawValue)) {
            return false;
        }
        if ("true".equalsIgnoreCase(rawValue)) {
            return true;
        }
        return null;
    }

    private static final class FileOptions
    implements TrailingSpacesOptionsProvider.Options {
        @Nullable
        private final Boolean myTrimTrailingSpaces;
        @Nullable
        private final Boolean myInsertFinalNewLine;

        private FileOptions(@Nullable Boolean spaces, @Nullable Boolean line) {
            this.myTrimTrailingSpaces = spaces;
            this.myInsertFinalNewLine = line;
        }

        @Nullable
        public Boolean getStripTrailingSpaces() {
            return this.myTrimTrailingSpaces;
        }

        @Nullable
        public Boolean getEnsureNewLineAtEOF() {
            return this.myInsertFinalNewLine;
        }

        @Nullable
        public Boolean getRemoveTrailingBlankLines() {
            return null;
        }

        @Nullable
        public Boolean getChangedLinesOnly() {
            return this.myTrimTrailingSpaces != null ? Boolean.valueOf(this.myTrimTrailingSpaces == false) : null;
        }

        @Nullable
        public Boolean getKeepTrailingSpacesOnCaretLine() {
            return null;
        }
    }
}

