/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigEncodingInspection
extends LocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!file.equals(EditorConfigEncodingInspection.getMainPsi(file))) {
            return null;
        }
        Project project = manager.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && Utils.isEnabled(CodeStyle.getSettings((Project)project)) && virtualFile.isWritable()) {
            if (EditorConfigEncodingInspection.isHardcodedCharsetOrFailed(virtualFile)) {
                return null;
            }
            EditorConfigEncodingCache encodingCache = EditorConfigEncodingCache.getInstance();
            if (encodingCache.isIgnored(virtualFile)) {
                return null;
            }
            EditorConfigEncodingCache.CharsetData charsetData = encodingCache.getCharsetData(file.getProject(), file.getVirtualFile(), false);
            if (charsetData != null && !virtualFile.getCharset().equals(charsetData.getCharset())) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, EditorConfigBundle.message("inspection.file.encoding.mismatch.descriptor", charsetData.getCharset().displayName()), new LocalQuickFix[]{new ApplyEditorConfigEncodingQuickFix(), new IgnoreFileQuickFix()}, ProblemHighlightType.WARNING, isOnTheFly, false)};
            }
        }
        return null;
    }

    private static boolean isHardcodedCharsetOrFailed(@NotNull VirtualFile virtualFile) {
        FileType fileType = virtualFile.getFileType();
        try {
            String charsetName = fileType.getCharset(virtualFile, virtualFile.contentsToByteArray());
            return charsetName != null;
        }
        catch (IOException e) {
            return true;
        }
    }

    @NotNull
    private static PsiFile getMainPsi(@NotNull PsiFile psiFile) {
        Language baseLanguage = psiFile.getViewProvider().getBaseLanguage();
        return psiFile.getViewProvider().getPsi(baseLanguage);
    }

    private static void showError(@NotNull Project project, @Nls @NotNull String title, @Nls @NotNull String message2) {
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("editorconfig");
        Notifications.Bus.notify((Notification)group.createNotification(title, message2, NotificationType.ERROR), (Project)project);
    }

    private static class ApplyEditorConfigEncodingQuickFix
    implements LocalQuickFix {
        private ApplyEditorConfigEncodingQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.apply");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                EditorConfigEncodingCache.getInstance().computeAndCacheEncoding(project, file);
                try {
                    LoadTextUtil.write((Project)project, (VirtualFile)file, (Object)file, (String)document.getText(), (long)document.getModificationStamp());
                }
                catch (IOException e) {
                    EditorConfigEncodingInspection.showError(project, EditorConfigBundle.message("inspection.file.encoding.save.error"), e.getLocalizedMessage());
                }
            }
        }
    }

    private static class IgnoreFileQuickFix
    implements LocalQuickFix {
        private IgnoreFileQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return EditorConfigBundle.message("inspection.file.encoding.ignore");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            EditorConfigEncodingCache.getInstance().setIgnored(file);
        }
    }
}

