/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.ProjectService;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/game/ProjectServiceImpl;", "Lcom/android/tools/game/ProjectService;", "()V", "pool", "", "", "Lcom/intellij/openapi/project/Project;", "projectManager", "Lcom/intellij/openapi/project/ex/ProjectManagerEx;", "createProject", "name", "path", "Ljava/nio/file/Path;", "getProject", "projectId", "android.game-tools.main"})
public final class ProjectServiceImpl
implements ProjectService {
    @NotNull
    private final ProjectManagerEx projectManager = ProjectManagerEx.Companion.getInstanceEx();
    @NotNull
    private final Map<String, Project> pool = new LinkedHashMap();

    @Override
    @NotNull
    public Project getProject(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Project project2 = this.pool.get(projectId);
        if (project2 == null) {
            StatusRuntimeException statusRuntimeException = Status.NOT_FOUND.withDescription("Project '" + projectId + "' is not found.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"NOT_FOUND.withDescriptio\u2026d.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        return project2;
    }

    @Override
    @NotNull
    public String createProject(@NotNull String name, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription(path + " is not a valid directory to create project.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"INVALID_ARGUMENT.withDes\u2026t.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.toAbsolutePath()");
        Project project2 = this.projectManager.newProject(path2, OpenProjectTaskKt.OpenProjectTask((Function1)((Function1)new Function1<OpenProjectTaskBuilder, Unit>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            public final void invoke(@NotNull OpenProjectTaskBuilder $this$OpenProjectTask) {
                Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
                $this$OpenProjectTask.setNewProject(true);
                $this$OpenProjectTask.setRunConfigurators(false);
                $this$OpenProjectTask.setProjectName(this.$name);
            }
        })));
        if (project2 == null) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Cannot create project at location '" + path + "'.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"INTERNAL.withDescription\u2026'.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        Project project3 = project2;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String projectId = string;
        this.pool.put(projectId, project3);
        return projectId;
    }
}

