/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.AdbPath;
import com.android.tools.game.CommonWindowWrapper;
import com.android.tools.game.FakeToolWindow;
import com.android.tools.game.NoopToolWindowWrapper;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.ProfilerServiceKt;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/game/ProfilerServiceImpl;", "Lcom/android/tools/game/ProfilerService;", "()V", "initialized", "", "profilerWindowIcons", "", "Ljava/awt/Image;", "windowIdToProject", "", "", "Lcom/intellij/openapi/project/Project;", "windowWrappers", "Lcom/android/tools/game/CommonWindowWrapper;", "windows", "Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "createWindow", "windowId", "project", "getDeviceTimeNs", "", "deviceId", "startProfiler", "", "request", "Lcom/android/tools/game/protos/StartProfilingRequest;", "tryInitializeProfilerServices", "android.game-tools.main"})
@SourceDebugExtension(value={"SMAP\nProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerService.kt\ncom/android/tools/game/ProfilerServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class ProfilerServiceImpl
implements ProfilerService {
    @NotNull
    private final Map<String, CommonWindowWrapper> windowWrappers = new LinkedHashMap();
    @NotNull
    private final Map<Project, AndroidProfilerToolWindow> windows = new LinkedHashMap();
    @NotNull
    private final Map<String, Project> windowIdToProject = new LinkedHashMap();
    @NotNull
    private final List<Image> profilerWindowIcons;
    private boolean initialized;

    public ProfilerServiceImpl() {
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PROFILER");
        int[] nArray = new int[]{16, 32, 64, 256, 512};
        this.profilerWindowIcons = ProfilerServiceKt.iconToImages(icon, nArray);
    }

    @Override
    @NotNull
    public CommonWindowWrapper createWindow(@NotNull String windowId, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.tryInitializeProfilerServices();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, project2, windowId){
            final /* synthetic */ ProfilerServiceImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $windowId;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$windowId = $windowId;
            }

            public final void run() {
                V v = ProfilerServiceImpl.access$getWindows$p(this.this$0).computeIfAbsent(this.$project, new Function(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    @NotNull
                    public final AndroidProfilerToolWindow apply(@NotNull Project it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new AndroidProfilerToolWindow((ToolWindowWrapper)new NoopToolWindowWrapper(false, null, null, 7, null), this.$project);
                    }
                });
                Intrinsics.checkNotNullExpressionValue(v, (String)"project: Project): Commo\u2026apper(), project)\n      }");
                AndroidProfilerToolWindow window2 = (AndroidProfilerToolWindow)v;
                FakeToolWindow fakeToolWindow = new FakeToolWindow(this.$project);
                Object object = this.this$0;
                FakeToolWindow $this$run_u24lambda_u240 = fakeToolWindow;
                boolean bl = false;
                $this$run_u24lambda_u240.setTitle("Android Studio Profiler");
                $this$run_u24lambda_u240.setIconImages(ProfilerServiceImpl.access$getProfilerWindowIcons$p((ProfilerServiceImpl)object));
                $this$run_u24lambda_u240.setDefaultCloseOperation(2);
                $this$run_u24lambda_u240.setGlassPane((Component)new IdeGlassPaneImpl($this$run_u24lambda_u240.getRootPane()));
                $this$run_u24lambda_u240.add(window2.getComponent());
                $this$run_u24lambda_u240.setSize(new Dimension(800, 600));
                $this$run_u24lambda_u240.setUndecorated(false);
                $this$run_u24lambda_u240.setVisible(true);
                FakeToolWindow frame = fakeToolWindow;
                object = new CommonWindowWrapper(this.$windowId, frame);
                ProfilerServiceImpl profilerServiceImpl = this.this$0;
                String string = this.$windowId;
                Object $this$run_u24lambda_u241 = object;
                boolean bl2 = false;
                ((CommonWindowWrapper)$this$run_u24lambda_u241).addWindowCloseListener((Function0<Unit>)((Function0)new Function0<Unit>(profilerServiceImpl, string){
                    final /* synthetic */ ProfilerServiceImpl this$0;
                    final /* synthetic */ String $windowId;
                    {
                        this.this$0 = $receiver;
                        this.$windowId = $windowId;
                        super(0);
                    }

                    public final void invoke() {
                        ProfilerServiceImpl.access$getWindowWrappers$p(this.this$0).remove(this.$windowId);
                    }
                }));
                Object windowWrapper2 = object;
                AndroidNotification.setFallbackNotificationDestination((Project)this.$project, (JFrame)frame);
                ProfilerServiceImpl.access$getWindowIdToProject$p(this.this$0).put(this.$windowId, this.$project);
                ProfilerServiceImpl.access$getWindowWrappers$p(this.this$0).put(this.$windowId, windowWrapper2);
            }
        });
        CommonWindowWrapper commonWindowWrapper = this.windowWrappers.get(windowId);
        Intrinsics.checkNotNull((Object)commonWindowWrapper);
        return commonWindowWrapper;
    }

    @Override
    public void startProfiler(@NotNull StartProfilingRequest request) {
        Object v7;
        StudioProfilers profilers;
        AndroidProfilerToolWindow window2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.tryInitializeProfilerServices();
            Project project2 = this.windowIdToProject.get(request.getWindowId());
            if (project2 == null) {
                StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Window '" + request.getWindowId() + "' cannot be found.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
            Project projectId = project2;
            AndroidProfilerToolWindow androidProfilerToolWindow = this.windows.get(projectId);
            if (androidProfilerToolWindow == null) {
                StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Project '" + projectId + "' cannot be found.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
            window2 = androidProfilerToolWindow;
            StudioProfilers studioProfilers = window2.getProfilers();
            if (studioProfilers == null) {
                StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Cannot initialize profilers.").asRuntimeException();
                Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INTERNAL.withDescription\u2026s.\").asRuntimeException()");
                throw (Throwable)statusRuntimeException;
            }
            profilers = studioProfilers;
            List list = profilers.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"profilers.devices");
            Iterable iterable = list;
            for (Object t : iterable) {
                Common.Device it = (Common.Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSerial(), (Object)request.getSerialNumber())) continue;
                v7 = t;
                break block5;
            }
            v7 = null;
        }
        Common.Device device = v7;
        if (device == null) {
            StatusRuntimeException statusRuntimeException = Status.INVALID_ARGUMENT.withDescription("Device " + request.getSerialNumber() + " cannot be found.").asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"INVALID_ARGUMENT.withDes\u2026d.\").asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        Common.Device device2 = device;
        long deviceTimeNs = this.getDeviceTimeNs(device2.getDeviceId());
        long systemTimeMs = System.currentTimeMillis();
        long processLaunchTimeMinBoundNs = Duration.ofMillis(request.getStartLaterThanMs() - systemTimeMs).toNanos() + deviceTimeNs;
        String string = device2.getManufacturer();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.manufacturer");
        String string2 = device2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.model");
        String string3 = device2.getSerial();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"device.serial");
        PreferredProcessInfo preferredProcessInfo2 = new PreferredProcessInfo(AndroidProfilerToolWindow.Companion.getDeviceDisplayName(string, string2, string3), request.getApplicationId(), (Function1)new Function1<Common.Process, Boolean>(processLaunchTimeMinBoundNs){
            final /* synthetic */ long $processLaunchTimeMinBoundNs;
            {
                this.$processLaunchTimeMinBoundNs = $processLaunchTimeMinBoundNs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Common.Process it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStartTimestampNs() >= this.$processLaunchTimeMinBoundNs;
            }
        });
        profilers.getDeviceProcessMap().clear();
        window2.profile(preferredProcessInfo2);
    }

    private final long getDeviceTimeNs(long deviceId) {
        ProfilerClient client = new ProfilerClient(TransportService.Companion.getChannelName());
        try {
            Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
            return timeResponse.getTimestampNs();
        }
        catch (StatusRuntimeException exception) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withCause((Throwable)exception).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"INTERNAL.withCause(exception).asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
    }

    private final void tryInitializeProfilerServices() {
        if (this.initialized) {
            return;
        }
        File adbPath = AdbPath.INSTANCE.get();
        try {
            AdbService.getInstance().getDebugBridge(adbPath).get();
            AndroidProfilerService.getInstance();
        }
        catch (Exception e) {
            StatusRuntimeException statusRuntimeException = Status.UNKNOWN.withDescription("Failed to start profiler: " + e.getMessage()).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"UNKNOWN\n        .withDes\u2026    .asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
        this.initialized = true;
    }

    public static final /* synthetic */ Map access$getWindows$p(ProfilerServiceImpl $this) {
        return $this.windows;
    }

    public static final /* synthetic */ Map access$getWindowIdToProject$p(ProfilerServiceImpl $this) {
        return $this.windowIdToProject;
    }

    public static final /* synthetic */ Map access$getWindowWrappers$p(ProfilerServiceImpl $this) {
        return $this.windowWrappers;
    }

    public static final /* synthetic */ List access$getProfilerWindowIcons$p(ProfilerServiceImpl $this) {
        return $this.profilerWindowIcons;
    }
}

