/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.game.ArgumentParser;
import com.android.tools.game.AvdManagerServiceImpl;
import com.android.tools.game.CommonService;
import com.android.tools.game.CommonWindowWrapper;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.GameToolsServer;
import com.android.tools.game.GameToolsStarter;
import com.android.tools.game.LogcatServiceImpl;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.ProjectServiceImpl;
import com.android.tools.game.SdkManagerServiceImpl;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import java.awt.Font;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/android/tools/game/GameToolsStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "isHeadless", "", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "requiredModality", "", "getRequiredModality", "()I", "fatal", "", "mode", "Lcom/android/tools/game/GameToolsStarter$Mode;", "message", "initializeSdk", "", "sdkPath", "Ljava/io/File;", "main", "args", "", "startApp", "Lcom/android/tools/game/CommonWindowWrapper;", "service", "Lcom/android/tools/game/CommonService;", "project", "Lcom/intellij/openapi/project/Project;", "AppWindow", "Mode", "android.game-tools.main"})
@SourceDebugExtension(value={"SMAP\nGameToolsStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameToolsStarter.kt\ncom/android/tools/game/GameToolsStarter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,258:1\n10#2:259\n37#3,2:260\n1#4:262\n11335#5:263\n11670#5,3:264\n11335#5:267\n11670#5,3:268\n*S KotlinDebug\n*F\n+ 1 GameToolsStarter.kt\ncom/android/tools/game/GameToolsStarter\n*L\n56#1:259\n82#1:260,2\n143#1:263\n143#1:264,3\n170#1:267\n170#1:268,3\n*E\n"})
public final class GameToolsStarter
implements ApplicationStarter {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String commandName;
    private final boolean isHeadless;
    private final int requiredModality;

    public GameToolsStarter() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GameToolsStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.logger = logger;
        this.commandName = "game-tools";
        this.isHeadless = true;
        this.requiredModality = 2;
    }

    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull List<String> args) {
        block32: {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ArgumentParser params = new ArgumentParser().parse(thisCollection$iv.toArray(new String[0]));
            try {
                File sdkPath;
                File file;
                Keymap keymap;
                AppWindow appWindow;
                Mode mode;
                Integer port;
                block31: {
                    Keymap sdkPathOptions2;
                    AppWindow appWindow2;
                    int n;
                    Mode mode2;
                    Keymap it;
                    String string = params.getPort();
                    port = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                    Keymap keymap2 = params.getMode();
                    if (keymap2 != null) {
                        it = keymap2;
                        boolean bl = false;
                        mode2 = Mode.valueOf((String)it);
                    } else {
                        mode2 = null;
                    }
                    mode = mode2;
                    String string2 = params.getAppWindow();
                    if (string2 != null) {
                        String it2 = string2;
                        n = 0;
                        appWindow2 = AppWindow.valueOf(it2);
                    } else {
                        appWindow2 = null;
                    }
                    appWindow = appWindow2;
                    it = new Keymap[]{new Function0<File>(params){
                        final /* synthetic */ ArgumentParser $params;
                        {
                            this.$params = $params;
                            super(0);
                        }

                        @Nullable
                        public final File invoke() {
                            File file;
                            String string = this.$params.getSdkPath();
                            if (string != null) {
                                String it = string;
                                boolean bl = false;
                                file = new File(it);
                            } else {
                                file = null;
                            }
                            return file;
                        }
                    }, main.sdkPathOptions.2.INSTANCE, main.sdkPathOptions.3.INSTANCE, main.sdkPathOptions.4.INSTANCE};
                    keymap = sdkPathOptions2 = it;
                    int n2 = ((Function0[])keymap).length;
                    for (n = 0; n < n2; ++n) {
                        Function0 it3 = keymap[n];
                        boolean bl = false;
                        file = (File)it3.invoke();
                        if (file == null) {
                            continue;
                        }
                        break block31;
                    }
                    file = null;
                }
                if ((sdkPath = file) == null) {
                    this.fatal(mode, "Cannot find Android SDK on your system. Please install the Android SDK and set the 'ANDROID_SDK_ROOT' environment variable.");
                    throw new KotlinNothingValueException();
                }
                File file2 = sdkPath.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"sdkPath.absoluteFile");
                this.initializeSdk(FilesKt.normalize((File)file2));
                AndroidStudioAnalytics.getInstance().initializeAndroidStudioUsageTrackerAndPublisher();
                Runtime.getRuntime().addShutdownHook(new Thread(main.1.INSTANCE));
                SplashManager.hide();
                Keymap $this$main_u24lambda_u243 = keymap = KeymapManager.getInstance().getActiveKeymap();
                boolean bl = false;
                $this$main_u24lambda_u243.removeAllActionShortcuts("GotoAction");
                $this$main_u24lambda_u243.removeAllActionShortcuts("ShowSettings");
                AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GAME_TOOLS_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(AndroidStudioUsageTracker.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails());
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n          .\u2026onMetricsData.jvmDetails)");
                UsageTracker.log((AndroidStudioEvent.Builder)builder);
                Mode mode3 = mode;
                switch (mode3 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[mode3.ordinal()]) {
                    case 1: {
                        if (port == null) {
                            this.fatal(mode, "You must specify a port with '--port' in SERVER mode.");
                            throw new KotlinNothingValueException();
                        }
                        new GameToolsServer(port, null, null, null, null, null, null, 126, null).start();
                        break;
                    }
                    case 2: {
                        AppWindow appWindow3 = appWindow;
                        CommonService service = switch (appWindow3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[appWindow3.ordinal()]) {
                            case 1 -> new ProfilerServiceImpl();
                            case 2 -> new SdkManagerServiceImpl();
                            case 3 -> new AvdManagerServiceImpl();
                            case 4 -> new DeviceFileExplorerServiceImpl();
                            case 5 -> new LogcatServiceImpl();
                            default -> {
                                void $this$mapTo$iv$iv;
                                AppWindow[] $this$map$iv = AppWindow.values();
                                boolean $i$f$map = false;
                                AppWindow[] var16_28 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                int var20_37 = ((void)$this$mapTo$iv$iv).length;
                                for (int var19_35 = 0; var19_35 < var20_37; ++var19_35) {
                                    void it;
                                    void item$iv$iv;
                                    void var22_41 = item$iv$iv = $this$mapTo$iv$iv[var19_35];
                                    Collection var25_45 = destination$iv$iv;
                                    boolean $i$a$-map-GameToolsStarter$main$service$options$1 = false;
                                    var25_45.add(it.toString());
                                }
                                List options = (List)destination$iv$iv;
                                this.fatal(mode, "You must specify a valid window to open with '--app-window [" + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + "] in APP mode.");
                                throw new KotlinNothingValueException();
                            }
                        };
                        ProjectServiceImpl it = new ProjectServiceImpl();
                        boolean bl2 = false;
                        Path path = Paths.get(SystemProperties.getUserHome(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.getUserHome())");
                        Project project2 = it.getProject(it.createProject("Empty Project", path));
                        this.startApp(service, project2);
                        break;
                    }
                    case 3: {
                        GameToolsServer gameToolsServer = new GameToolsServer(0, null, null, null, null, null, null, 126, null);
                        gameToolsServer.start();
                        gameToolsServer.shutdown();
                        ProjectServiceImpl it = new ProjectServiceImpl();
                        boolean bl3 = false;
                        Path path = Paths.get(SystemProperties.getUserHome(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.getUserHome())");
                        Project project2 = it.getProject(it.createProject("Empty Project", path));
                        AppWindow appWindow4 = appWindow;
                        switch (appWindow4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[appWindow4.ordinal()]) {
                            case 1: {
                                this.startApp(new ProfilerServiceImpl(), project2).closeWindow();
                                break block32;
                            }
                            case 2: {
                                CommonWindowWrapper $this$main_u24lambda_u247 = bl3 = this.startApp(new SdkManagerServiceImpl(), project2);
                                boolean bl4 = false;
                                $this$main_u24lambda_u247.addWindowOpenListener((Function0<Unit>)((Function0)new Function0<Unit>($this$main_u24lambda_u247){
                                    final /* synthetic */ CommonWindowWrapper $this_apply;
                                    {
                                        this.$this_apply = $receiver;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.$this_apply.closeWindow();
                                    }
                                }));
                                break block32;
                            }
                            case 3: {
                                this.startApp(new AvdManagerServiceImpl(), project2).closeWindow();
                                break block32;
                            }
                            case 4: {
                                this.startApp(new DeviceFileExplorerServiceImpl(), project2).closeWindow();
                                break block32;
                            }
                            case 5: {
                                this.startApp(new LogcatServiceImpl(), project2).closeWindow();
                                break block32;
                            }
                            default: {
                                void $this$mapTo$iv$iv;
                                AppWindow[] $this$map$iv = AppWindow.values();
                                boolean $i$f$map = false;
                                AppWindow[] destination$iv$iv = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                int n = ((void)$this$mapTo$iv$iv).length;
                                for (int i = 0; i < n; ++i) {
                                    void it4;
                                    void item$iv$iv;
                                    void $i$a$-map-GameToolsStarter$main$service$options$1 = item$iv$iv = $this$mapTo$iv$iv[i];
                                    Collection collection = destination$iv$iv2;
                                    boolean bl5 = false;
                                    collection.add(it4.toString());
                                }
                                List options = (List)destination$iv$iv2;
                                this.fatal(mode, "You must specify a valid window to open with '--app-window [" + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + "] in VERIFY mode.");
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    default: {
                        this.fatal(mode, "You must specify a mode with '--mode [APP|SERVER|VERIFY]'.");
                        throw new KotlinNothingValueException();
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error("GameToolsServer crashed!", e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Void fatal(Mode mode, String message) {
        try {
            File ideaLog = new File(PathManager.getLogPath(), "idea.log");
            if (mode == Mode.SERVER || mode == Mode.VERIFY) {
                this.logger.error(message + " For more details, see " + ideaLog);
            }
            Font $this$fatal_u24lambda_u249 = new JLabel().getFont();
            boolean bl = false;
            String style = StringsKt.trimIndent((String)("\n          font-family:" + $this$fatal_u24lambda_u249.getFamily() + ";\n          font-weight:" + ($this$fatal_u24lambda_u249.isBold() ? "bold" : "normal") + ";\n          font-size:" + $this$fatal_u24lambda_u249.getSize() + "pt;\n        "));
            JEditorPane messagePane = new JEditorPane("text/html", StringsKt.trimIndent((String)("\n          <html>\n            <body style=\"" + style + "\">\n              " + message + "\n              <br>\n              For more details, see the <a href=\"#placeholder\">idea.log</a>.\n            </body>\n          </html>\n          ")));
            messagePane.addHyperlinkListener(new HyperlinkListener(ideaLog){
                final /* synthetic */ File $ideaLog;
                {
                    this.$ideaLog = $ideaLog;
                }

                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        RevealFileAction.openFile((File)this.$ideaLog);
                    }
                }
            });
            messagePane.setEditable(false);
            messagePane.setBackground(new JLabel().getBackground());
            JOptionPane.showMessageDialog(null, messagePane, "Error", 0);
        }
        finally {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final CommonWindowWrapper startApp(CommonService service, Project project2) {
        CommonWindowWrapper commonWindowWrapper;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String windowId = string;
        CommonWindowWrapper $this$startApp_u24lambda_u2410 = commonWindowWrapper = service.createWindow(windowId, project2);
        boolean bl = false;
        $this$startApp_u24lambda_u2410.addWindowCloseListener((Function0<Unit>)((Function0)startApp.1.1.INSTANCE));
        return commonWindowWrapper;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public int getRequiredModality() {
        return this.requiredModality;
    }

    private final void initializeSdk(File sdkPath) {
        block3: {
            block2: {
                new File(sdkPath, "platforms").mkdirs();
                ApplicationManager.getApplication().runWriteAction(new Runnable(sdkPath){
                    final /* synthetic */ File $sdkPath;
                    {
                        this.$sdkPath = $sdkPath;
                    }

                    public final void run() {
                        IdeSdks.getInstance().setAndroidSdkPath(this.$sdkPath);
                    }
                });
                if (IdeSdks.getInstance().getAndroidSdkPath() == null) break block2;
                File file = IdeSdks.getInstance().getAndroidSdkPath();
                Intrinsics.checkNotNull((Object)file);
                if (file.exists()) break block3;
            }
            this.fatal(null, "Cannot set Android SDK path");
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/game/GameToolsStarter$AppWindow;", "", "(Ljava/lang/String;I)V", "PROFILER", "SDK_MANAGER", "AVD_MANAGER", "DEVICE_FILE_EXPLORER", "LOGCAT", "android.game-tools.main"})
    private static final class AppWindow
    extends Enum<AppWindow> {
        public static final /* enum */ AppWindow PROFILER = new AppWindow();
        public static final /* enum */ AppWindow SDK_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow AVD_MANAGER = new AppWindow();
        public static final /* enum */ AppWindow DEVICE_FILE_EXPLORER = new AppWindow();
        public static final /* enum */ AppWindow LOGCAT = new AppWindow();
        private static final /* synthetic */ AppWindow[] $VALUES;

        public static AppWindow[] values() {
            return (AppWindow[])$VALUES.clone();
        }

        public static AppWindow valueOf(String value) {
            return Enum.valueOf(AppWindow.class, value);
        }

        static {
            $VALUES = appWindowArray = new AppWindow[]{AppWindow.PROFILER, AppWindow.SDK_MANAGER, AppWindow.AVD_MANAGER, AppWindow.DEVICE_FILE_EXPLORER, AppWindow.LOGCAT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/game/GameToolsStarter$Mode;", "", "(Ljava/lang/String;I)V", "SERVER", "APP", "VERIFY", "android.game-tools.main"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode SERVER = new Mode();
        public static final /* enum */ Mode APP = new Mode();
        public static final /* enum */ Mode VERIFY = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.SERVER, Mode.APP, Mode.VERIFY};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AppWindow.values().length];
            try {
                nArray[AppWindow.PROFILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.SDK_MANAGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.AVD_MANAGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.DEVICE_FILE_EXPLORER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppWindow.LOGCAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Mode.values().length];
            try {
                nArray[Mode.SERVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.VERIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

