/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraHTTPHeadersParser {
    @NotNull
    public static Map<String, String> parse(@Nullable String data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        try {
            String[] pairs;
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            for (String pair : pairs = data.split(";")) {
                String[] strings = pair.split("=");
                if (strings.length != 2 || "" == strings[0] || "" == strings[1]) continue;
                res.put(strings[0], strings[1]);
            }
            return res;
        }
        catch (Exception ignored) {
            return Collections.emptyMap();
        }
    }

    @NotNull
    public static String serialize(@NotNull Map<String, String> headers) {
        StringBuilder stringBuilder = new StringBuilder();
        headers.forEach((k, v) -> {
            stringBuilder.append((String)k);
            stringBuilder.append('=');
            stringBuilder.append((String)v);
            stringBuilder.append(';');
        });
        if (!headers.isEmpty()) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

