/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemErrorEvent
extends ExternalSystemEvent {
    private final String myEvent;
    private final String myErrorClass;

    public ExternalSystemErrorEvent(long timestamp, @NotNull String event, @NotNull Throwable th, @Nullable String recorder) {
        this(timestamp, event, th.getClass().getName(), recorder);
    }

    public ExternalSystemErrorEvent(long timestamp, @NotNull String event, @NotNull String errorClass, @Nullable String recorder) {
        super(ExternalSystemEventType.ERROR, timestamp, recorder);
        this.myEvent = event;
        this.myErrorClass = errorClass;
    }

    @NotNull
    public String getEvent() {
        return this.myEvent;
    }

    @NotNull
    public String getErrorClass() {
        return this.myErrorClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalSystemErrorEvent event = (ExternalSystemErrorEvent)o;
        return Objects.equals(this.myEvent, event.myEvent) && Objects.equals(this.myErrorClass, event.myErrorClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myEvent, this.myErrorClass);
    }
}

