/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventSerializer;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalEventsLogger
implements DataCollectorSystemEventLogger {
    private static final int CURRENT_VERSION = 1;
    @NonNls
    private final Logger myLogger = Logger.getLogger("com.intellij.internal.statistic.uploader.events");

    public ExternalEventsLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            this.myLogger.addHandler(ExternalEventsLogger.newAppender(ExternalEventsLogger.getEventLogFile(logDirectory, 1).getAbsolutePath()));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @NotNull
    public static Handler newAppender(@NotNull String logPath) {
        try {
            @NonNls FileHandler appender = new FileHandler(logPath, false);
            appender.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            appender.setLevel(Level.ALL);
            return appender;
        }
        catch (IOException e) {
            System.err.println("Error creating log file: " + e.getMessage());
            return new ConsoleHandler();
        }
    }

    @NotNull
    private static File getEventLogFile(@NotNull String logDirectory, int version) {
        return new File(logDirectory, "idea_statistics_uploader_events_v" + version + ".log");
    }

    public void logSendingLogsStarted() {
        this.logEvent(new ExternalUploadStartedEvent(System.currentTimeMillis(), null));
    }

    public void logSendingLogsFinished(@NotNull String error) {
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, null));
    }

    public void logSendingLogsFinished(@NotNull String recorderId, @NotNull String error) {
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, recorderId));
    }

    public void logSendingLogsFinished(@NotNull String recorderId, @NotNull StatisticsResult.ResultCode code) {
        String error = code == StatisticsResult.ResultCode.SEND ? null : code.name();
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error, recorderId));
    }

    public void logSendingLogsSucceed(@NotNull String recorderId, @NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int total) {
        int succeed = successfullySentFiles.size();
        int failed = errors.size();
        this.logEvent(new ExternalUploadSendEvent(System.currentTimeMillis(), succeed, failed, total, successfullySentFiles, errors, recorderId));
    }

    @Override
    public void logErrorEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull Throwable exception) {
        this.logEvent(new ExternalSystemErrorEvent(System.currentTimeMillis(), eventId, exception, recorderId));
    }

    private void logEvent(@NotNull ExternalSystemEvent event) {
        this.myLogger.info(ExternalSystemEventSerializer.serialize(event));
    }

    @NotNull
    public static List<ExternalSystemEvent> parseEvents(@NotNull File directory) throws IOException {
        List<String> lines;
        VersionedFile versionedFile = VersionedFile.find(directory.getAbsolutePath());
        List<String> list = lines = versionedFile.file.exists() ? Files.readAllLines(versionedFile.file.toPath()) : Collections.emptyList();
        if (!lines.isEmpty()) {
            ArrayList<ExternalSystemEvent> events = new ArrayList<ExternalSystemEvent>();
            for (String line : lines) {
                ExternalSystemEvent event = ExternalSystemEventSerializer.deserialize(line, versionedFile.version);
                if (event == null) continue;
                events.add(event);
            }
            return events;
        }
        return Collections.emptyList();
    }

    private static class VersionedFile {
        protected final File file;
        protected final int version;

        private VersionedFile(@NotNull File file, int version) {
            this.file = file;
            this.version = version;
        }

        @NotNull
        protected static VersionedFile find(@NotNull String logDirectory) {
            int version = 0;
            File file = new File(logDirectory, "idea_statistics_uploader_events.log");
            if (!file.exists()) {
                file = ExternalEventsLogger.getEventLogFile(logDirectory, ++version);
            }
            return new VersionedFile(file, version);
        }
    }
}

