/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDataCollectorLogger
implements DataCollectorDebugLogger {
    @NonNls
    private final Logger myLogger = Logger.getLogger("com.intellij.internal.statistic.uploader");

    public ExternalDataCollectorLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            String logPath = new File(logDirectory, "idea_statistics_uploader.log").getAbsolutePath();
            this.myLogger.addHandler(ExternalDataCollectorLogger.newAppender(logPath));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @Nullable
    public static String findDirectory(long requiredFreeSpace) {
        String dir = System.getProperty("java.io.tmpdir");
        if (dir != null && ExternalDataCollectorLogger.isValidDir(dir, requiredFreeSpace)) {
            return dir;
        }
        return null;
    }

    private static boolean isValidDir(String path, long space) {
        File dir = new File(path);
        return dir.isDirectory() && dir.canWrite() && dir.getUsableSpace() >= space;
    }

    @NotNull
    private static Handler newAppender(@NotNull String logPath) {
        try {
            @NonNls FileHandler appender = new FileHandler(logPath, false);
            appender.setLevel(Level.ALL);
            appender.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String level = record.getLevel() == Level.WARNING ? "WARN" : record.getLevel().toString();
                    String result = String.format("%1$td/%1$tm %1$tT %2$5s %3$s - %4$s%5$s", record.getMillis(), level, record.getLoggerName(), record.getMessage(), System.lineSeparator());
                    Throwable thrown = record.getThrown();
                    if (thrown != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        thrown.printStackTrace(pw);
                        return result + sw;
                    }
                    return result;
                }
            });
            return appender;
        }
        catch (IOException e) {
            System.err.println("Error creating log file: " + e.getMessage());
            return new ConsoleHandler();
        }
    }

    @Override
    public void info(String message) {
        this.myLogger.info(message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.myLogger.log(Level.INFO, message, t);
    }

    @Override
    public void warn(String message) {
        this.myLogger.warning(message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.myLogger.log(Level.WARNING, message, t);
    }

    @Override
    public void trace(String message) {
        this.myLogger.finer(message);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isLoggable(Level.FINER);
    }
}

