/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public abstract class ProjectUsagesCollector
extends FeatureUsagesCollector {
    @ApiStatus.Internal
    public static final ExtensionPointName<ProjectUsagesCollector> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.projectUsagesCollector");

    @NotNull
    public static Set<ProjectUsagesCollector> getExtensions(@NotNull UsagesCollectorConsumer invoker) {
        return ProjectUsagesCollector.getExtensions(invoker, EP_NAME);
    }

    @NotNull
    public CancellablePromise<? extends Set<MetricEvent>> getMetrics(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (this.requiresReadAccess()) {
            NonBlockingReadAction action = ReadAction.nonBlocking(() -> this.getMetrics(project));
            if (indicator != null) {
                action = action.wrapProgress(indicator);
            }
            return action.expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance());
        }
        return Promises.resolvedCancellablePromise(this.getMetrics(project));
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        return Collections.emptySet();
    }

    protected boolean requiresReadAccess() {
        return false;
    }
}

