/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.service.fus.collectors.AllowedDuringStartupCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class FeatureUsagesCollector {
    @NonNls
    private static final Logger LOG = Logger.getInstance(FeatureUsagesCollector.class);
    @NonNls
    private static final String GROUP_ID_PATTERN = "([a-zA-Z]*\\.)*[a-zA-Z]*";

    public final boolean isValid() {
        return Pattern.compile(GROUP_ID_PATTERN).matcher(this.getGroupId()).matches();
    }

    protected static <T extends FeatureUsagesCollector> Set<T> getExtensions(@NotNull UsagesCollectorConsumer invoker, ExtensionPointName<T> ep, boolean allowedOnStartupOnly) {
        if (invoker.getClass().getClassLoader() instanceof PluginAwareClassLoader) {
            return Collections.emptySet();
        }
        HashSet<FeatureUsagesCollector> set = new HashSet<FeatureUsagesCollector>();
        List extensionList = allowedOnStartupOnly ? ep.findExtensions(AllowedDuringStartupCollector.class) : ep.getExtensionList();
        for (FeatureUsagesCollector t : extensionList) {
            if (t.isValid()) {
                set.add(t);
                continue;
            }
            LOG.info(t + " is !valid -> skipped from extension points list");
        }
        return set;
    }

    protected static <T extends FeatureUsagesCollector> Set<T> getExtensions(@NotNull UsagesCollectorConsumer invoker, ExtensionPointName<T> ep) {
        return FeatureUsagesCollector.getExtensions(invoker, ep, false);
    }

    @Deprecated(forRemoval=true)
    @NonNls
    @NotNull
    public String getGroupId() {
        EventLogGroup group = this.getGroup();
        if (group == null) {
            throw PluginException.createByClass((String)("Please override either getGroupId() or getGroup() in " + this.getClass().getName()), null, this.getClass());
        }
        return group.getId();
    }

    @Deprecated(forRemoval=true)
    public int getVersion() {
        EventLogGroup group = this.getGroup();
        if (group != null) {
            return group.getVersion();
        }
        return 1;
    }

    public EventLogGroup getGroup() {
        return null;
    }
}

