/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogTestMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final Logger LOG = Logger.getInstance(EventLogTestMetadataPersistence.class);
    public static final String TEST_RULE = "{util#fus_test_mode}";
    private static final String DEPRECATED_TEST_EVENTS_SCHEME_FILE = "test-white-list.json";
    private static final String TEST_EVENTS_SCHEME_FILE = "test-events-scheme.json";
    @NotNull
    private final String myRecorderId;

    public EventLogTestMetadataPersistence(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsTestSchemeFile();
            return Files.readString(file);
        }
        catch (NoSuchFileException file) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void cleanup() {
        try {
            Files.deleteIfExists(this.getEventsTestSchemeFile());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static EventGroupRemoteDescriptors.EventGroupRemoteDescriptor createGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) {
        String content = "{\"id\":\"" + groupId + "\",\"versions\":[ {\"from\" : \"1\"}],\"rules\":" + rules + "}";
        return (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)new GsonBuilder().create().fromJson(content, EventGroupRemoteDescriptors.EventGroupRemoteDescriptor.class);
    }

    public static void addTestGroup(@NotNull String recorderId, @NotNull GroupValidationTestRule group) throws IOException {
        String groupId = group.getGroupId();
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor groupWithRules = group.getUseCustomRules() ? EventLogTestMetadataPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()) : EventLogTestMetadataPersistence.createTestGroup(groupId, Collections.emptySet());
        EventLogTestMetadataPersistence.addNewGroup(recorderId, groupWithRules);
    }

    private static void addNewGroup(@NotNull String recorderId, @NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group) throws IOException {
        EventLogTestMetadataPersistence persistence = new EventLogTestMetadataPersistence(recorderId);
        EventGroupRemoteDescriptors approvedGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(persistence);
        EventLogTestMetadataPersistence.saveNewGroup(group, approvedGroups, persistence.getEventsTestSchemeFile());
    }

    public static void saveNewGroup(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull EventGroupRemoteDescriptors approvedGroups, @NotNull Path file) throws IOException {
        ArrayList descriptors = approvedGroups.groups;
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor g : approvedGroups.groups) {
            if (!Objects.equals(g.id, group.id)) continue;
            descriptors.remove(g);
            break;
        }
        approvedGroups.groups.add(group);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            gson.toJson((Object)approvedGroups, EventGroupRemoteDescriptors.class, (Appendable)writer);
        }
    }

    @NotNull
    public static EventGroupRemoteDescriptors loadCachedEventGroupsSchemes(@NotNull BaseEventLogMetadataPersistence persistence) {
        String existing = persistence.getCachedEventsScheme();
        if (Strings.isNotEmpty((String)existing)) {
            try {
                return EventLogMetadataUtils.parseGroupRemoteDescriptors(existing);
            }
            catch (EventLogMetadataParseException e) {
                LOG.warn("Failed parsing test cached events scheme", (Throwable)e);
            }
        }
        return new EventGroupRemoteDescriptors();
    }

    @NotNull
    public static EventGroupRemoteDescriptors.EventGroupRemoteDescriptor createTestGroup(@NotNull String groupId, @NotNull Set<String> eventData) {
        EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group = new EventGroupRemoteDescriptors.EventGroupRemoteDescriptor();
        group.id = groupId;
        if (group.versions != null) {
            group.versions.add(new EventGroupRemoteDescriptors.GroupVersionRange("1", null));
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rule = new EventGroupRemoteDescriptors.GroupRemoteRule();
        rule.event_id = new HashSet<String>(Collections.singletonList(TEST_RULE));
        HashMap<String, HashSet<String>> dataRules = new HashMap<String, HashSet<String>>();
        for (String datum : eventData) {
            dataRules.put(datum, new HashSet<String>(Collections.singletonList(TEST_RULE)));
        }
        rule.event_data = dataRules;
        group.rules = rule;
        return group;
    }

    @NotNull
    public Path getEventsTestSchemeFile() throws IOException {
        return EventLogTestMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, TEST_EVENTS_SCHEME_FILE, DEPRECATED_TEST_EVENTS_SCHEME_FILE);
    }

    public void updateTestGroups(@NotNull List<GroupValidationTestRule> groups) throws IOException {
        EventGroupRemoteDescriptors approvedGroups = new EventGroupRemoteDescriptors();
        for (GroupValidationTestRule group : groups) {
            String groupId = group.getGroupId();
            if (group.getUseCustomRules()) {
                approvedGroups.groups.add(EventLogTestMetadataPersistence.createGroupWithCustomRules(groupId, group.getCustomRules()));
                continue;
            }
            approvedGroups.groups.add(EventLogTestMetadataPersistence.createTestGroup(groupId, Collections.emptySet()));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path file = this.getEventsTestSchemeFile();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            gson.toJson((Object)approvedGroups, EventGroupRemoteDescriptors.class, (Appendable)writer);
        }
    }
}

