/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEventLogMetadataPersistence {
    private static final Logger LOG = Logger.getInstance(BaseEventLogMetadataPersistence.class);
    public static final String DEPRECATED_FUS_METADATA_DIR = "event-log-whitelist";
    public static final String FUS_METADATA_DIR = "event-log-metadata";

    @Nullable
    public abstract String getCachedEventsScheme();

    public static Path getDefaultMetadataFile(@NotNull String recorderId, @NotNull String fileName, @Nullable String deprecatedFileName) throws IOException {
        Path deprecated;
        Path file = BaseEventLogMetadataPersistence.getMetadataByDir(FUS_METADATA_DIR, recorderId, fileName);
        if (!Files.exists(file, new LinkOption[0]) && Strings.isNotEmpty((String)deprecatedFileName) && Files.exists(deprecated = BaseEventLogMetadataPersistence.getMetadataByDir(DEPRECATED_FUS_METADATA_DIR, recorderId, deprecatedFileName), new LinkOption[0])) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving deprecated metadata file to new directory: " + fileName);
            }
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException ignored) {
                LOG.info("Cannot create directories for event log metadata");
                return file;
            }
            Files.copy(deprecated, file, new CopyOption[0]);
            Files.deleteIfExists(deprecated);
        }
        return file;
    }

    @NotNull
    public static Path getDeprecatedMetadataDir() {
        return BaseEventLogMetadataPersistence.getMetadataConfigRoot(DEPRECATED_FUS_METADATA_DIR);
    }

    @NotNull
    private static Path getMetadataByDir(@NotNull String dir, @NotNull String recorderId, @NotNull String fileName) throws IOException {
        Path metadataDir = BaseEventLogMetadataPersistence.getMetadataConfigRoot(dir);
        return metadataDir.resolve(StringUtil.toLowerCase((String)recorderId)).resolve(fileName).normalize().toAbsolutePath();
    }

    @NotNull
    private static Path getMetadataConfigRoot(@NotNull String dir) {
        return PathManager.getConfigDir().resolve(dir);
    }
}

