/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class EventLogServerMetadataLoader
implements EventLogMetadataLoader {
    @NotNull
    private final EventLogUploadSettingsService mySettingsService;

    public EventLogServerMetadataLoader(@NotNull String recorderId) {
        this.mySettingsService = StatisticsUploadAssistant.createExternalSettings(recorderId, false, TimeUnit.HOURS.toMillis(1L));
    }

    @Override
    public long getLastModifiedOnServer() {
        EventLogConnectionSettings settings = this.mySettingsService.getApplicationInfo().getConnectionSettings();
        return EventLogMetadataUtils.lastModifiedMetadata(this.mySettingsService.getMetadataProductUrl(), settings);
    }

    @Override
    @NotNull
    public String loadMetadataFromServer() throws EventLogMetadataLoadException {
        EventLogConnectionSettings settings = this.mySettingsService.getApplicationInfo().getConnectionSettings();
        return EventLogMetadataUtils.loadMetadataFromServer(this.mySettingsService.getMetadataProductUrl(), settings);
    }

    @Override
    @NotNull
    public Map<String, String> getOptionValues() {
        return this.mySettingsService.getOptions();
    }
}

