/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.AllowedItemsResourceStorageBase;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.AllowedItemsResourceWeakRefStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import org.jetbrains.annotations.NotNull;

public abstract class LocalFileCustomValidationRule
extends CustomValidationRule {
    private final AllowedItemsResourceStorageBase storage;
    private final String ruleId;

    protected LocalFileCustomValidationRule(@NotNull String ruleId, @NotNull Class<?> resource, @NotNull String path) {
        this.ruleId = ruleId;
        this.storage = new AllowedItemsResourceWeakRefStorage(resource, path);
    }

    protected LocalFileCustomValidationRule(@NotNull String ruleId, @NotNull AllowedItemsResourceStorageBase storage) {
        this.ruleId = ruleId;
        this.storage = storage;
    }

    @Override
    @NotNull
    public String getRuleId() {
        return this.ruleId;
    }

    private boolean isAllowed(@NotNull String value) {
        return this.storage.getItems().contains(value);
    }

    @NotNull
    protected final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (LocalFileCustomValidationRule.isThirdPartyValue(data) || this.isAllowed(data)) {
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }
}

