/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PayloadKey;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomValidationRule
extends PerformanceCareRule
implements FUSRule,
UtilValidationRule {
    public static final ExtensionPointName<CustomValidationRule> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.validation.customValidationRule");
    public static final PayloadKey<PluginInfo> PLUGIN_INFO = new PayloadKey("plugin_info");

    public boolean acceptRuleId(@Nullable @NonNls String ruleId) {
        return this.getRuleId().equals(ruleId);
    }

    @NotNull
    public String getRuleId() {
        throw new UnsupportedOperationException(String.format("The method getRuleId must be overridden in %s", ((Object)((Object)this)).getClass()));
    }

    public static <T extends CustomValidationRule> T getCustomValidationRuleInstance(Class<T> clazz) {
        Optional<CustomValidationRule> optionalCustomValidationRule = EP_NAME.getExtensionList().stream().filter(customValidationRule -> ((Object)customValidationRule).getClass() == clazz).findFirst();
        if (optionalCustomValidationRule.isEmpty()) {
            throw new IllegalStateException(String.format("CustomValidationRule instance is not found for class %s.", clazz.getName()));
        }
        return (T)((Object)optionalCustomValidationRule.get());
    }

    @NotNull
    protected static ValidationResultType acceptWhenReportedByPluginFromPluginRepository(@NotNull EventContext context) {
        PluginType type;
        Object pluginType = context.eventData.get("plugin_type");
        PluginType pluginType2 = type = pluginType != null ? PluginInfoDetectorKt.findPluginTypeByValue(pluginType.toString()) : null;
        if (type == null || !type.isSafeToReport()) {
            return ValidationResultType.REJECTED;
        }
        if (type.isPlatformOrJvm() || type == PluginType.FROM_SOURCES || CustomValidationRule.hasPluginField(context)) {
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }

    @NotNull
    protected static ValidationResultType acceptWhenReportedByJetBrainsPlugin(@NotNull EventContext context) {
        return CustomValidationRule.isReportedByJetBrainsPlugin(context) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    protected static boolean isReportedByJetBrainsPlugin(@NotNull EventContext context) {
        PluginType type;
        Object pluginType = context.eventData.get("plugin_type");
        PluginType pluginType2 = type = pluginType != null ? PluginInfoDetectorKt.findPluginTypeByValue(pluginType.toString()) : null;
        if (type == null || !type.isDevelopedByJetBrains()) {
            return false;
        }
        return type.isPlatformOrJvm() || type == PluginType.FROM_SOURCES || CustomValidationRule.hasPluginField(context);
    }

    protected static boolean hasPluginField(@NotNull EventContext context) {
        if (context.eventData.containsKey("plugin")) {
            Object plugin = context.eventData.get("plugin");
            return plugin instanceof String && StringUtil.isNotEmpty((String)((String)plugin));
        }
        return false;
    }

    protected static boolean isThirdPartyValue(@NotNull String data) {
        return ValidationResultType.THIRD_PARTY.getDescription().equals(data);
    }

    protected static boolean isPluginFromPluginRepository(@NotNull String plugin) {
        PluginId pluginId = PluginId.findId((String)plugin);
        return pluginId != null && PluginInfoDetectorKt.getPluginInfoById(pluginId).isSafeToReport();
    }

    @Nullable
    protected Language getLanguage(@NotNull EventContext context) {
        Object id = context.eventData.get("lang");
        return id instanceof String ? Language.findLanguageByID((String)((String)id)) : null;
    }

    @Nullable
    protected String getEventDataField(@NotNull EventContext context, @NotNull String name) {
        return context.eventData.containsKey(name) ? context.eventData.get(name).toString() : null;
    }
}

