/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AllowedItemsResourceStorageBase {
    private static final Logger LOG = Logger.getInstance(AllowedItemsResourceStorageBase.class);
    private final Class<?> resourceHolder;
    private final String relativePath;

    public AllowedItemsResourceStorageBase(@NotNull Class<?> holder, @NotNull String path) {
        this.resourceHolder = holder;
        this.relativePath = path;
    }

    @Nullable
    protected String createValue(@NotNull String value) {
        return value.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected Set<String> readItems() {
        try {
            InputStream resourceStream = this.resourceHolder.getResourceAsStream(this.relativePath);
            if (resourceStream == null) {
                throw new IOException("Resource " + this.relativePath + " not found");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
                List values = FileUtil.loadLines((BufferedReader)reader);
                if (values.isEmpty()) return Collections.emptySet();
                Set set = ContainerUtil.map2SetNotNull((Collection)values, s -> this.createValue((String)s));
                return set;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return Collections.emptySet();
    }

    @NotNull
    public abstract Set<String> getItems();
}

