/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.events.scheme.EventSchemeValidator;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsScheme;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDataType;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "getPluginsToSkipSchemeGeneration", "", "logEnabledPlugins", "", "pluginsFile", "main", "args", "", "FieldDataTypeSerializer", "intellij.platform.statistics"})
public final class EventsSchemeBuilderAppStarter
implements ApplicationStarter {
    @NotNull
    public String getCommandName() {
        return "buildEventsScheme";
    }

    public void main(@NotNull List<String> args) {
        String outputFile = null;
        String pluginsFile = null;
        String pluginId = null;
        for (String arg : args) {
            if (StringsKt.startsWith$default((String)arg, (String)"--outputFile=", (boolean)false, (int)2, null)) {
                outputFile = StringsKt.substringAfter$default((String)arg, (String)"--outputFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--pluginsFile=", (boolean)false, (int)2, null)) {
                pluginsFile = StringsKt.substringAfter$default((String)arg, (String)"--pluginsFile=", null, (int)2, null);
                continue;
            }
            if (!StringsKt.startsWith$default((String)arg, (String)"--pluginId=", (boolean)false, (int)2, null)) continue;
            pluginId = StringsKt.substringAfter$default((String)arg, (String)"--pluginId=", null, (int)2, null);
        }
        List<GroupDescriptor> groups = EventsSchemeBuilder.buildEventsScheme(null, pluginId, this.getPluginsToSkipSchemeGeneration());
        List<String> errors = EventSchemeValidator.validateEventScheme(groups);
        if (!((Collection)errors).isEmpty()) {
            throw new IllegalStateException(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        EventsScheme eventsScheme = new EventsScheme(System.getenv("INSTALLER_LAST_COMMIT_HASH"), System.getenv("IDEA_BUILD_NUMBER"), groups);
        String text = new GsonBuilder().registerTypeAdapter((Type)((Object)FieldDataType.class), (Object)FieldDataTypeSerializer.INSTANCE).setPrettyPrinting().create().toJson((Object)eventsScheme);
        this.logEnabledPlugins(pluginsFile);
        if (outputFile != null) {
            FileUtil.writeToFile((File)new File(outputFile), (String)text);
        } else {
            System.out.println((Object)text);
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void logEnabledPlugins(String pluginsFile) {
        StringBuilder stringBuilder;
        StringBuilder $this$logEnabledPlugins_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getLoadedPlugins()) {
            if (!descriptor.isEnabled()) continue;
            StringBuilder stringBuilder2 = $this$logEnabledPlugins_u24lambda_u240.append(descriptor.getPluginId().getIdString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string;
        if (pluginsFile != null) {
            FileUtil.writeToFile((File)new File(pluginsFile), (String)text);
        } else {
            System.out.println((Object)"Enabled plugins:");
            System.out.println((Object)text);
        }
    }

    private final Set<String> getPluginsToSkipSchemeGeneration() {
        String skipGenerationOfBrokenPlugins = System.getenv("SKIP_GENERATION_OF_BROKEN_PLUGINS");
        if (skipGenerationOfBrokenPlugins == null) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{","};
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)skipGenerationOfBrokenPlugins, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter$FieldDataTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDataType;", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "intellij.platform.statistics"})
    public static final class FieldDataTypeSerializer
    implements JsonSerializer<FieldDataType> {
        @NotNull
        public static final FieldDataTypeSerializer INSTANCE = new FieldDataTypeSerializer();

        private FieldDataTypeSerializer() {
        }

        @NotNull
        public JsonElement serialize(@Nullable FieldDataType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            if (src == FieldDataType.PRIMITIVE || src == null) {
                JsonSerializationContext jsonSerializationContext = context;
                Intrinsics.checkNotNull((Object)jsonSerializationContext);
                return jsonSerializationContext.serialize(null);
            }
            JsonSerializationContext jsonSerializationContext = context;
            Intrinsics.checkNotNull((Object)jsonSerializationContext);
            return jsonSerializationContext.serialize((Object)src.name());
        }
    }
}

