/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0007J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\"\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$H\u0002J:\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010\u00042\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventSchemeValidator;", "", "()V", "SYMBOLS_TO_REPLACE_FIELD_NAME", "", "containsChar", "", "str", "c", "", "containsSystemSymbols", "value", "toReplace", "isAscii", "isAsciiControl", "isProhibitedSymbol", "isSymbolToReplace", "isWhiteSpaceToReplace", "unwrapRule", "rule", "validateEventScheme", "", "eventsScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "validateEvents", "schema", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/EventDescriptor;", "groupId", "validateFields", "fields", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDescriptor;", "eventId", "validateGroupScheme", "group", "validatedGroupNames", "", "validateRules", "fieldName", "rules", "intellij.platform.statistics"})
public final class EventSchemeValidator {
    @NotNull
    public static final EventSchemeValidator INSTANCE = new EventSchemeValidator();
    @NotNull
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ":;, ";

    private EventSchemeValidator() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> validateEventScheme(@NotNull List<GroupDescriptor> eventsScheme) {
        HashSet groupNames = new HashSet();
        ArrayList errors = new ArrayList();
        for (GroupDescriptor group : CollectionsKt.toSet((Iterable)eventsScheme)) {
            errors.addAll(INSTANCE.validateGroupScheme(group, groupNames));
        }
        return errors;
    }

    private final List<String> validateGroupScheme(GroupDescriptor group, Set<String> validatedGroupNames) {
        ArrayList<Object> errors = new ArrayList<Object>();
        String groupId = group.getId();
        if (StringsKt.isBlank((CharSequence)groupId)) {
            errors.add("Group id is null or empty");
        }
        if (!validatedGroupNames.add(groupId)) {
            errors.add("Duplicate group `" + groupId + "`");
        }
        if (group.getVersion() <= 0) {
            errors.add("Group version should be not null and > 0 (groupId=" + groupId + ")");
        }
        errors.addAll((Collection)this.validateEvents(group.getSchema(), groupId));
        return errors;
    }

    private final List<String> validateEvents(Set<EventDescriptor> schema, String groupId) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        if (schema.isEmpty()) {
            errors.add((CallSite)((Object)("Group should contains at least one event (groupId=" + groupId + ")")));
            return errors;
        }
        HashSet<String> eventsNames = new HashSet<String>();
        for (EventDescriptor event : schema) {
            String eventId = event.getEvent();
            if (StringsKt.isBlank((CharSequence)eventId)) {
                errors.add((CallSite)((Object)("Event id is null or empty (groupId=" + groupId + ")")));
            } else if (!eventsNames.add(eventId)) {
                errors.add((CallSite)((Object)("Duplicate event (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            if (this.containsSystemSymbols(eventId, null)) {
                errors.add((CallSite)((Object)("Only printable ASCII symbols except '\" are allowed in event name (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            errors.addAll((Collection)this.validateFields(event.getFields(), groupId, eventId));
        }
        return errors;
    }

    private final List<String> validateFields(Set<FieldDescriptor> fields, String groupId, String eventId) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (FieldDescriptor field : fields) {
            String fieldName = field.getPath();
            if (StringsKt.isBlank((CharSequence)fieldName)) {
                errors.add((CallSite)((Object)("Field path is empty (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            if (this.containsSystemSymbols(fieldName, SYMBOLS_TO_REPLACE_FIELD_NAME)) {
                errors.add((CallSite)((Object)("Only printable ASCII symbols except whitespaces and .:;,'\" are allowed in field name (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            errors.addAll((Collection)this.validateRules(groupId, eventId, fieldName, field.getValue()));
        }
        return errors;
    }

    private final List<String> validateRules(String groupId, String eventId, String fieldName, Set<String> rules) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        if (rules == null) {
            errors.add((CallSite)((Object)("Validation rules are not specified (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            return errors;
        }
        for (String validationRule : rules) {
            String rule;
            if (StringsKt.isBlank((CharSequence)validationRule)) {
                errors.add((CallSite)((Object)("Validation rule is null or empty (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            if (Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.*}") || Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.+}")) {
                errors.add((CallSite)((Object)("Regexp should be more strict to prevent accidentally reporting sensitive data (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            if (!StringsKt.startsWith$default((String)(rule = this.unwrapRule(validationRule)), (String)"enum:", (boolean)false, (int)2, null) || !this.containsSystemSymbols(validationRule, null)) continue;
            errors.add((CallSite)((Object)("Only printable ASCII symbols except '\" are allowed in validation rule (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
        }
        return errors;
    }

    private final String unwrapRule(String rule) {
        String string;
        String trimmedRule = ((Object)StringsKt.trim((CharSequence)rule)).toString();
        if (StringsKt.startsWith$default((String)trimmedRule, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmedRule, (String)"}", (boolean)false, (int)2, null)) {
            String string2 = trimmedRule.substring(1, trimmedRule.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = rule;
        }
        return string;
    }

    private final boolean containsSystemSymbols(String value, String toReplace) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char element = value.charAt(i);
            if (!this.isAscii(element)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(element)) {
                return true;
            }
            if (this.isSymbolToReplace(element, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(element)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    private final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char element = str.charAt(i);
            if (element != c) continue;
            return true;
        }
        return false;
    }
}

