/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestResult;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogMetadataUtils {
    @NotNull
    public static EventGroupsFilterRules<EventLogBuild> loadAndParseGroupsFilterRules(@NotNull String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        try {
            String content = EventLogMetadataUtils.loadMetadataFromServer(serviceUrl, settings);
            EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors(content);
            return EventGroupsFilterRules.create((EventGroupRemoteDescriptors)groups, (EventLogBuildParser)EventLogBuild.EVENT_LOG_BUILD_PRODUCER);
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            return EventGroupsFilterRules.empty();
        }
    }

    @NotNull
    public static EventGroupRemoteDescriptors parseGroupRemoteDescriptors(@Nullable String content) throws EventLogMetadataParseException {
        if (StatisticsStringUtil.isEmptyOrSpaces(content)) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.EMPTY_CONTENT);
        }
        try {
            EventGroupRemoteDescriptors groups = (EventGroupRemoteDescriptors)new GsonBuilder().create().fromJson(content, EventGroupRemoteDescriptors.class);
            if (groups != null) {
                return groups;
            }
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON);
        }
        catch (JsonSyntaxException e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON, (Throwable)e);
        }
        catch (Exception e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.UNKNOWN, (Throwable)e);
        }
    }

    @NotNull
    public static String loadMetadataFromServer(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) throws EventLogMetadataLoadException {
        if (StatisticsStringUtil.isEmptyOrSpaces(serviceUrl)) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.EMPTY_SERVICE_URL);
        }
        try {
            StatsRequestResult<String> result = StatsHttpRequests.request(serviceUrl, settings).send(r -> r.readAsString());
            if (result.isSucceed()) {
                return result.getResult();
            }
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.UNREACHABLE_SERVICE, result.getError());
        }
        catch (StatsResponseException | IOException e) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.ERROR_ON_LOAD, (Throwable)e);
        }
    }

    public static long lastModifiedMetadata(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        if (StatisticsStringUtil.isEmptyOrSpaces(serviceUrl)) {
            return 0L;
        }
        try {
            StatsRequestResult<Long> result = StatsHttpRequests.head(serviceUrl, settings).send(r -> r.lastModified());
            return result.getResult() != null ? result.getResult() : 0L;
        }
        catch (StatsResponseException | IOException e) {
            return 0L;
        }
    }
}

