/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.EventLogExternalSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.StatisticsCachingSupplier;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    @Nullable
    private final String myConfigUrl;
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;
    @NotNull
    private final Supplier<EventLogExternalSendSettings> myCachedExternalSettings;

    protected SettingsConnectionService(@Nullable String settingsUrl, @NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        this.myConfigUrl = settingsUrl;
        this.myApplicationInfo = appInfo;
        this.myCachedExternalSettings = new StatisticsCachingSupplier<EventLogExternalSendSettings>(() -> this.myConfigUrl != null ? this.loadSettings(recorderId, this.myConfigUrl, this.myApplicationInfo.getProductVersion()) : null, settingsCacheTimeoutMs);
    }

    @Nullable
    protected EventLogSendConfiguration getConfiguration(@NotNull EventLogBuildType type) {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null ? settings.getConfiguration(type) : null;
    }

    @Nullable
    protected String getEndpointValue(@NotNull String attribute) {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null ? settings.getEndpoint(attribute) : null;
    }

    @NotNull
    public Map<String, String> getOptions() {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null ? settings.getOptions() : Collections.emptyMap();
    }

    @Nullable
    protected synchronized EventLogExternalSendSettings getExternalSettings() {
        return this.myCachedExternalSettings.get();
    }

    @Nullable
    public EventLogExternalSendSettings loadSettings(@NotNull String recorderId, @NotNull String configUrl, @NotNull String appVersion) {
        try {
            return StatsHttpRequests.request(configUrl, this.myApplicationInfo.getConnectionSettings()).send(r -> {
                try {
                    InputStream content = r.read();
                    if (content != null) {
                        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
                        return EventLogExternalSettings.parseSendSettings(reader, appVersion);
                    }
                    return null;
                }
                catch (EventLogConfigParserException e) {
                    throw new StatsResponseException(e);
                }
            }).getResult();
        }
        catch (StatsResponseException | IOException e) {
            this.logError(recorderId, e);
            return null;
        }
    }

    private void logError(@NotNull String recorderId, Exception e) {
        String message = String.format(Locale.ENGLISH, "%s: %s", e.getClass().getName(), Objects.requireNonNullElse(e.getMessage(), "No message provided"));
        if (e instanceof ConnectException || e instanceof HttpTimeoutException || e instanceof SSLHandshakeException || e instanceof StatsResponseException) {
            this.myApplicationInfo.getLogger().info(message);
        } else {
            this.myApplicationInfo.getLogger().warn(message, e);
        }
        this.myApplicationInfo.getEventLogger().logErrorEvent(recorderId, "loading.config.failed", e);
    }
}

