/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.config;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.EventLogBasicConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogExternalApplicationInfo
implements EventLogApplicationInfo {
    private final DataCollectorDebugLogger myLogger;
    private final DataCollectorSystemEventLogger myEventLogger;
    private final String myTemplateUrl;
    private final String myProductCode;
    private final String myProductVersion;
    private final EventLogBasicConnectionSettings myConnectionSettings;
    private final boolean myIsInternal;
    private final boolean myIsTest;
    private final boolean myIsEAP;

    public EventLogExternalApplicationInfo(@NotNull String templateUrl, @NotNull String productCode, @NotNull String productVersion, @Nullable String userAgent, boolean isInternal, boolean isTest, boolean isEAP, @NotNull Map<String, String> extraHeaders, @NotNull DataCollectorDebugLogger logger, @NotNull DataCollectorSystemEventLogger eventLogger) {
        this.myTemplateUrl = templateUrl;
        this.myProductCode = productCode;
        this.myProductVersion = productVersion;
        String externalUserAgent = (userAgent == null ? "IntelliJ" : userAgent) + "(External)";
        this.myConnectionSettings = new EventLogBasicConnectionSettings(externalUserAgent, extraHeaders);
        this.myIsInternal = isInternal;
        this.myIsTest = isTest;
        this.myIsEAP = isEAP;
        this.myLogger = logger;
        this.myEventLogger = eventLogger;
    }

    @Override
    @NotNull
    public String getTemplateUrl() {
        return this.myTemplateUrl;
    }

    @Override
    @NotNull
    public String getProductCode() {
        return this.myProductCode;
    }

    @Override
    @NotNull
    public String getProductVersion() {
        return this.myProductVersion;
    }

    @Override
    @NotNull
    public EventLogConnectionSettings getConnectionSettings() {
        return this.myConnectionSettings;
    }

    @Override
    public boolean isInternal() {
        return this.myIsInternal;
    }

    @Override
    public boolean isTest() {
        return this.myIsTest;
    }

    @Override
    public boolean isEAP() {
        return this.myIsEAP;
    }

    @Override
    @NotNull
    public DataCollectorDebugLogger getLogger() {
        return this.myLogger;
    }

    @Override
    @NotNull
    public DataCollectorSystemEventLogger getEventLogger() {
        return this.myEventLogger;
    }
}

