/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsSystemEventIdProvider;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B[\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020)H\u0016J4\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020100H\u0002JB\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u001a\u00106\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000201\u0018\u000100072\u0006\u00108\u001a\u00020\u0007H\u0016J:\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000201002\u0006\u00108\u001a\u00020\u0007H\u0016J\b\u0010:\u001a\u00020#H\u0002J\b\u0010;\u001a\u00020#H\u0016R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "Lcom/intellij/openapi/Disposable;", "recorderId", "", "sessionId", "headless", "", "build", "bucket", "recorderVersion", "writer", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "systemEventIdProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;", "mergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "ideMode", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;Lcom/intellij/internal/statistic/eventLog/StatisticsSystemEventIdProvider;Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;Ljava/lang/String;)V", "eventMergeTimeoutMs", "", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "lastEventCreatedTime", "lastEventFlushFuture", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "lastEventTime", "logExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getLogExecutor", "()Ljava/util/concurrent/ExecutorService;", "cleanup", "", "dispose", "flush", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "event", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "createdTime", "rawEventId", "rawData", "", "", "logAsync", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "dataProvider", "Lkotlin/Function0;", "isState", "data", "logLastEvent", "rollOver", "FusEvent", "intellij.platform.statistics"})
public class StatisticsFileEventLogger
implements StatisticsEventLogger,
Disposable {
    @NotNull
    private final String recorderId;
    @NotNull
    private final String sessionId;
    private final boolean headless;
    @NotNull
    private final String build;
    @NotNull
    private final String bucket;
    @NotNull
    private final String recorderVersion;
    @NotNull
    private final StatisticsEventLogWriter writer;
    @NotNull
    private final StatisticsSystemEventIdProvider systemEventIdProvider;
    @NotNull
    private final StatisticsEventMergeStrategy mergeStrategy;
    @Nullable
    private final String ideMode;
    @NotNull
    private final ExecutorService logExecutor;
    @Nullable
    private FusEvent lastEvent;
    private long lastEventTime;
    private long lastEventCreatedTime;
    private long eventMergeTimeoutMs;
    @Nullable
    private ScheduledFuture<CompletableFuture<Void>> lastEventFlushFuture;

    public StatisticsFileEventLogger(@NotNull String recorderId, @NotNull String sessionId, boolean headless, @NotNull String build2, @NotNull String bucket, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter writer, @NotNull StatisticsSystemEventIdProvider systemEventIdProvider, @NotNull StatisticsEventMergeStrategy mergeStrategy, @Nullable String ideMode) {
        this.recorderId = recorderId;
        this.sessionId = sessionId;
        this.headless = headless;
        this.build = build2;
        this.bucket = bucket;
        this.recorderVersion = recorderVersion;
        this.writer = writer;
        this.systemEventIdProvider = systemEventIdProvider;
        this.mergeStrategy = mergeStrategy;
        this.ideMode = ideMode;
        this.logExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("StatisticsFileEventLogger: " + this.sessionId), (int)1);
        this.eventMergeTimeoutMs = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) ? 500L : 10000L;
    }

    public /* synthetic */ StatisticsFileEventLogger(String string, String string2, boolean bl, String string3, String string4, String string5, StatisticsEventLogWriter statisticsEventLogWriter, StatisticsSystemEventIdProvider statisticsSystemEventIdProvider, StatisticsEventMergeStrategy statisticsEventMergeStrategy, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            statisticsEventMergeStrategy = new FilteredEventMergeStrategy(SetsKt.emptySet());
        }
        if ((n & 0x200) != 0) {
            string6 = null;
        }
        this(string, string2, bl, string3, string4, string5, statisticsEventLogWriter, statisticsSystemEventIdProvider, statisticsEventMergeStrategy, string6);
    }

    @NotNull
    protected final ExecutorService getLogExecutor() {
        return this.logExecutor;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState) {
        CompletableFuture<Void> completableFuture;
        long eventTime = System.currentTimeMillis();
        group.validateEventId$intellij_platform_statistics(eventId);
        try {
            completableFuture = CompletableFuture.runAsync(() -> StatisticsFileEventLogger.logAsync$lambda$0(this, group, eventTime, eventId, isState, data), this.logExecutor);
        }
        catch (RejectedExecutionException e) {
            CompletableFuture completableFuture2;
            CompletableFuture it = completableFuture2 = new CompletableFuture();
            boolean bl = false;
            it.completeExceptionally(e);
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> logAsync(@NotNull EventLogGroup group, @NotNull String eventId, @NotNull Function0<? extends Map<String, ? extends Object>> dataProvider, boolean isState) {
        Map map = (Map)dataProvider.invoke();
        if (map == null) {
            return CompletableFuture.completedFuture(null);
        }
        Map data = map;
        return this.logAsync(group, eventId, data, isState);
    }

    /*
     * Unable to fully structure code
     */
    private final void log(LogEvent event, long createdTime, String rawEventId, Map<String, ? extends Object> rawData) {
        if (this.lastEvent == null || event.getTime() - this.lastEventTime > this.eventMergeTimeoutMs) ** GOTO lbl-1000
        v0 = this.lastEvent;
        Intrinsics.checkNotNull((Object)v0);
        if (this.mergeStrategy.shouldMerge(v0.getValidatedEvent(), event)) {
            this.lastEventTime = event.getTime();
            v1 = this.lastEvent;
            Intrinsics.checkNotNull((Object)v1);
            v1.getValidatedEvent().getEvent().increment();
        } else lbl-1000:
        // 2 sources

        {
            this.logLastEvent();
            this.lastEvent = StatisticsRecorderUtil.isTestModeEnabled(this.recorderId) != false ? new FusEvent(event, rawEventId, rawData) : new FusEvent(event, null, null);
            this.lastEventTime = event.getTime();
            this.lastEventCreatedTime = createdTime;
        }
        if (StatisticsRecorderUtil.isTestModeEnabled(this.recorderId)) {
            v2 = this.lastEventFlushFuture;
            if (v2 != null) {
                v2.cancel(false);
            }
            this.lastEventFlushFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule((Callable<CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, flush(), ()Ljava/util/concurrent/CompletableFuture;)((StatisticsFileEventLogger)this), this.eventMergeTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private final void logLastEvent() {
        FusEvent fusEvent = this.lastEvent;
        if (fusEvent != null) {
            FusEvent it = fusEvent;
            boolean bl = false;
            LogEventAction event = it.getValidatedEvent().getEvent();
            if (event.isEventGroup()) {
                event.getData().put("last", this.lastEventTime);
            }
            event.getData().put("created", this.lastEventCreatedTime);
            long systemEventId = this.systemEventIdProvider.getSystemEventId(this.recorderId);
            Long l = systemEventId;
            event.getData().put("system_event_id", l);
            this.systemEventIdProvider.setSystemEventId(this.recorderId, ++systemEventId);
            if (this.headless) {
                event.getData().put("system_headless", true);
            }
            String string = this.ideMode;
            if (string != null) {
                String it2 = string;
                boolean bl2 = false;
                event.getData().put("ide_mode", this.ideMode);
            }
            this.writer.log(it.getValidatedEvent());
            ((EventLogListenersManager)ApplicationManager.getApplication().getService(EventLogListenersManager.class)).notifySubscribers(this.recorderId, it.getValidatedEvent(), it.getRawEventId(), it.getRawData());
        }
        this.lastEvent = null;
    }

    @Override
    @Nullable
    public EventLogFile getActiveLogFile() {
        return this.writer.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.writer.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.writer.cleanup();
    }

    @Override
    public void rollOver() {
        this.writer.rollOver();
    }

    public void dispose() {
        ScheduledFuture<CompletableFuture<Void>> scheduledFuture = this.lastEventFlushFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.flush();
        this.logExecutor.shutdown();
        Disposer.dispose((Disposable)this.writer);
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        return CompletableFuture.runAsync(() -> StatisticsFileEventLogger.flush$lambda$4(this), this.logExecutor);
    }

    private static final void logAsync$lambda$0(StatisticsFileEventLogger this$0, EventLogGroup $group, long $eventTime, String $eventId, boolean $isState, Map $data) {
        IntellijSensitiveDataValidator validator = IntellijSensitiveDataValidator.getInstance(this$0.recorderId);
        if (!validator.isGroupAllowed($group)) {
            return;
        }
        LogEvent event = StatisticsEventEscaperKt.escape((LogEvent)new LogEvent(this$0.sessionId, this$0.build, this$0.bucket, $eventTime, new LogEventGroup($group.getId(), String.valueOf($group.getVersion())), this$0.recorderVersion, new LogEventAction($eventId, $isState, (Map)new HashMap($data), 0, 8, null)));
        LogEvent validatedEvent = validator.validateEvent(event);
        if (validatedEvent != null) {
            this$0.log(validatedEvent, System.currentTimeMillis(), $eventId, $data);
        }
    }

    private static final void flush$lambda$4(StatisticsFileEventLogger this$0) {
        this$0.logLastEvent();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsFileEventLogger$FusEvent;", "", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "", "rawData", "", "(Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;Ljava/lang/String;Ljava/util/Map;)V", "getRawData", "()Ljava/util/Map;", "getRawEventId", "()Ljava/lang/String;", "getValidatedEvent", "()Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    private static final class FusEvent {
        @NotNull
        private final LogEvent validatedEvent;
        @Nullable
        private final String rawEventId;
        @Nullable
        private final Map<String, Object> rawData;

        public FusEvent(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            this.validatedEvent = validatedEvent;
            this.rawEventId = rawEventId;
            this.rawData = rawData;
        }

        @NotNull
        public final LogEvent getValidatedEvent() {
            return this.validatedEvent;
        }

        @Nullable
        public final String getRawEventId() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> getRawData() {
            return this.rawData;
        }

        @NotNull
        public final LogEvent component1() {
            return this.validatedEvent;
        }

        @Nullable
        public final String component2() {
            return this.rawEventId;
        }

        @Nullable
        public final Map<String, Object> component3() {
            return this.rawData;
        }

        @NotNull
        public final FusEvent copy(@NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
            return new FusEvent(validatedEvent, rawEventId, rawData);
        }

        public static /* synthetic */ FusEvent copy$default(FusEvent fusEvent, LogEvent logEvent, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                logEvent = fusEvent.validatedEvent;
            }
            if ((n & 2) != 0) {
                string = fusEvent.rawEventId;
            }
            if ((n & 4) != 0) {
                map = fusEvent.rawData;
            }
            return fusEvent.copy(logEvent, string, map);
        }

        @NotNull
        public String toString() {
            return "FusEvent(validatedEvent=" + this.validatedEvent + ", rawEventId=" + this.rawEventId + ", rawData=" + this.rawData + ")";
        }

        public int hashCode() {
            int result = this.validatedEvent.hashCode();
            result = result * 31 + (this.rawEventId == null ? 0 : this.rawEventId.hashCode());
            result = result * 31 + (this.rawData == null ? 0 : ((Object)this.rawData).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FusEvent)) {
                return false;
            }
            FusEvent fusEvent = (FusEvent)other;
            if (!Intrinsics.areEqual((Object)this.validatedEvent, (Object)fusEvent.validatedEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rawEventId, (Object)fusEvent.rawEventId)) {
                return false;
            }
            return Intrinsics.areEqual(this.rawData, fusEvent.rawData);
        }
    }
}

