/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class StatisticsEventLogMigration {
    public static void performMigration() {
        StatisticsEventLogMigration.moveLogsToNewFolder();
        StatisticsEventLogMigration.clearDeprecatedMetadataFolder();
        FUStatisticsPersistence.clearLegacyStates();
    }

    private static void clearDeprecatedMetadataFolder() {
        StatisticsEventLogMigration.deleteDir(BaseEventLogMetadataPersistence.getDeprecatedMetadataDir());
    }

    private static void moveLogsToNewFolder() {
        File[] pluginLogDirectories;
        Path oldPluginsLogs;
        Path newEventLogDir = EventLogConfiguration.getInstance().getEventLogDataPath().resolve("logs");
        Path systemPath = Paths.get(PathManager.getSystemPath(), new String[0]);
        Path legacyDirectory = systemPath.resolve("event-log");
        if (Files.exists(legacyDirectory, new LinkOption[0])) {
            StatisticsEventLogMigration.copyDirContent(legacyDirectory.toFile(), newEventLogDir.resolve("FUS").toFile());
            StatisticsEventLogMigration.deleteDir(legacyDirectory);
        }
        if (Files.exists(oldPluginsLogs = systemPath.resolve("plugins-event-log"), new LinkOption[0]) && (pluginLogDirectories = oldPluginsLogs.toFile().listFiles()) != null) {
            for (File pluginsDirectory : pluginLogDirectories) {
                StatisticsEventLogMigration.copyDirContent(pluginsDirectory, newEventLogDir.resolve(pluginsDirectory.getName()).toFile());
            }
            StatisticsEventLogMigration.deleteDir(oldPluginsLogs);
        }
    }

    private static void deleteDir(Path path) {
        try {
            NioFiles.deleteRecursively((Path)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void copyDirContent(File fromDir, File toDir) {
        try {
            FileUtil.copyDirContent((File)fromDir, (File)toDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

