/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "()V", "createAction", "Lcom/jetbrains/fus/reporting/model/lion3/LogEventAction;", "obj", "Lcom/google/gson/JsonObject;", "context", "Lcom/google/gson/JsonDeserializationContext;", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "transformNumbers", "", "value", "intellij.platform.statistics.uploader"})
public final class LogEventJsonDeserializer
implements JsonDeserializer<LogEvent> {
    @NotNull
    public LogEvent deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String recorderVersion = obj.get("recorder_version").getAsString();
        String session = obj.get("session").getAsString();
        String build2 = obj.get("build").getAsString();
        String bucket = obj.get("bucket").getAsString();
        long time = obj.get("time").getAsLong();
        JsonObject group = obj.get("group").getAsJsonObject();
        String groupId = group.get("id").getAsString();
        String groupVersion = group.get("version").getAsString();
        JsonObject actionObj = obj.get("event").getAsJsonObject();
        LogEventAction action = this.createAction(actionObj, context);
        return new LogEvent(session, build2, bucket, time, new LogEventGroup(groupId, groupVersion), recorderVersion, action);
    }

    /*
     * WARNING - void declaration
     */
    private final Object transformNumbers(Object value) {
        Object object;
        if (value instanceof Double && ((Number)value).doubleValue() % 1.0 == 0.0) {
            object = MathKt.roundToLong((double)((Number)value).doubleValue());
        } else if (value instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                collection.add(v1 != null ? this.transformNumbers(v1) : it);
            }
            object = (List)destination$iv$iv;
        } else if (value instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Object entryValue;
                Map map = destination$iv$iv2;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object entryKey = entry.getKey();
                Object v = entryValue = entry.getValue();
                Object newValue = v != null ? this.transformNumbers(v) : entryValue;
                entry = TuplesKt.to(entryKey, newValue);
                map.put(entry.getFirst(), entry.getSecond());
            }
            object = destination$iv$iv2;
        } else {
            object = value;
        }
        return object;
    }

    @NotNull
    public final LogEventAction createAction(@NotNull JsonObject obj, @NotNull JsonDeserializationContext context) {
        JsonPrimitive count;
        String id = obj.get("id").getAsString();
        boolean isState = obj.has("state") && obj.get("state").getAsBoolean();
        HashMap data = new HashMap();
        if (obj.has("data")) {
            JsonObject dataObj = obj.getAsJsonObject("data");
            for (Map.Entry entry : ((Map)context.deserialize((JsonElement)dataObj, new TypeToken<HashMap<String, Object>>(){}.getType())).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ((Map)data).put(key, this.transformNumbers(value));
            }
        }
        if (obj.has("count") && (count = obj.get("count").getAsJsonPrimitive()).isNumber()) {
            int n = count.getAsInt();
            return new LogEventAction(id, isState, (Map)data, n);
        }
        return new LogEventAction(id, isState, (Map)data, 0, 8, null);
    }
}

