/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EventLogRecorderConfigOptionsListener
implements EventLogConfigOptionsListener {
    private final String myRecorderId;

    protected EventLogRecorderConfigOptionsListener(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
    }

    @Override
    public void optionsChanged(@NotNull String recorderId, @NotNull Map<String, String> options) {
        if (StringUtil.equals((CharSequence)this.myRecorderId, (CharSequence)recorderId)) {
            String machineIdSalt = options.get("id_salt");
            String machineIdSaltRevision = options.get("id_salt_revision");
            if (machineIdSalt != null && machineIdSaltRevision != null) {
                this.onMachineIdConfigurationChanged(machineIdSalt, EventLogOptions.tryParseInt(machineIdSaltRevision));
            }
        }
    }

    public abstract void onMachineIdConfigurationChanged(@Nullable String var1, int var2);
}

