/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.Service;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0010J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogListenersManager;", "", "()V", "subscribers", "Lcom/intellij/util/containers/MultiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "Lorg/jetbrains/annotations/NotNull;", "notifySubscribers", "", "recorderId", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "subscribe", "subscriber", "unsubscribe", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogListenersManager {
    @NotNull
    private final MultiMap<String, StatisticsEventLogListener> subscribers = MultiMap.createConcurrent();

    public final void notifySubscribers(@NotNull String recorderId, @NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
        Collection listeners = this.subscribers.get((Object)recorderId);
        for (StatisticsEventLogListener listener : listeners) {
            listener.onLogEvent(validatedEvent, rawEventId, rawData);
        }
    }

    public final void subscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        if (!PluginInfoDetectorKt.getPluginInfo(subscriber.getClass()).isDevelopedByJetBrains()) {
            return;
        }
        this.subscribers.putValue((Object)recorderId, (Object)subscriber);
    }

    public final void unsubscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        this.subscribers.remove((Object)recorderId, (Object)subscriber);
    }
}

