/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0003J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u0018\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 JB\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\"2\u0006\u0010\u0018\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 J\\\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H%0$\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\"\"\u0004\b\u0002\u0010%2\u0006\u0010\u0018\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0 JK\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u00032\u0012\b\u0002\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0+2\u0012\b\u0002\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0+2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010(H\u0007\u00a2\u0006\u0002\u0010.J/\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u00032\u001a\u00101\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0+\"\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b4R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "", "id", "", "version", "", "recorder", "(Ljava/lang/String;ILjava/lang/String;)V", "events", "", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "getEvents", "()Ljava/util/List;", "getId", "()Ljava/lang/String;", "getRecorder", "registeredEventIds", "", "registeredEvents", "", "getVersion", "()I", "addToRegisteredEvents", "", "eventId", "isEventIdValid", "", "registerEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "T1", "eventField1", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "T2", "eventField2", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "T3", "eventField3", "registerIdeActivity", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "activityName", "startEventAdditionalFields", "", "finishEventAdditionalFields", "parentActivity", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;[Lcom/intellij/internal/statistic/eventLog/events/EventField;Lcom/intellij/internal/statistic/IdeActivityDefinition;)Lcom/intellij/internal/statistic/IdeActivityDefinition;", "registerVarargEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "fields", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "validateEventId", "validateEventId$intellij_platform_statistics", "intellij.platform.statistics"})
public final class EventLogGroup {
    @NotNull
    private final String id;
    private final int version;
    @NotNull
    private final String recorder;
    @NotNull
    private final Set<String> registeredEventIds;
    @NotNull
    private final List<BaseEventId> registeredEvents;

    @JvmOverloads
    public EventLogGroup(@NotNull String id, int version, @NotNull String recorder) {
        this.id = id;
        this.version = version;
        this.recorder = recorder;
        this.registeredEventIds = new LinkedHashSet();
        this.registeredEvents = new ArrayList();
    }

    public /* synthetic */ EventLogGroup(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = "FUS";
        }
        this(string, n, string2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @NotNull
    public final List<BaseEventId> getEvents() {
        return this.registeredEvents;
    }

    private final void addToRegisteredEvents(BaseEventId eventId) {
        this.registeredEvents.add(eventId);
        this.registeredEventIds.add(eventId.getEventId());
    }

    @NotNull
    public final EventId registerEvent(@NotNull String eventId) {
        EventId eventId2;
        EventId it = eventId2 = new EventId(this, eventId);
        boolean bl = false;
        this.addToRegisteredEvents(it);
        return eventId2;
    }

    @NotNull
    public final <T1> EventId1<T1> registerEvent(@NotNull String eventId, @NotNull EventField<T1> eventField1) {
        EventId1<T1> eventId1;
        EventId1<T1> it = eventId1 = new EventId1<T1>(this, eventId, eventField1);
        boolean bl = false;
        this.addToRegisteredEvents(it);
        return eventId1;
    }

    @NotNull
    public final <T1, T2> EventId2<T1, T2> registerEvent(@NotNull String eventId, @NotNull EventField<T1> eventField1, @NotNull EventField<T2> eventField2) {
        EventId2<T1, T2> eventId2;
        EventId2<T1, T2> it = eventId2 = new EventId2<T1, T2>(this, eventId, eventField1, eventField2);
        boolean bl = false;
        this.addToRegisteredEvents(it);
        return eventId2;
    }

    @NotNull
    public final <T1, T2, T3> EventId3<T1, T2, T3> registerEvent(@NotNull String eventId, @NotNull EventField<T1> eventField1, @NotNull EventField<T2> eventField2, @NotNull EventField<T3> eventField3) {
        EventId3<T1, T2, T3> eventId3;
        EventId3<T1, T2, T3> it = eventId3 = new EventId3<T1, T2, T3>(this, eventId, eventField1, eventField2, eventField3);
        boolean bl = false;
        this.addToRegisteredEvents(it);
        return eventId3;
    }

    @NotNull
    public final VarargEventId registerVarargEvent(@NotNull String eventId, EventField<?> ... fields) {
        VarargEventId varargEventId;
        VarargEventId it = varargEventId = new VarargEventId(this, eventId, Arrays.copyOf(fields, fields.length));
        boolean bl = false;
        this.addToRegisteredEvents(it);
        return varargEventId;
    }

    @JvmOverloads
    @NotNull
    public final IdeActivityDefinition registerIdeActivity(@Nullable String activityName, @NotNull EventField<?>[] startEventAdditionalFields, @NotNull EventField<?>[] finishEventAdditionalFields, @Nullable IdeActivityDefinition parentActivity) {
        return new IdeActivityDefinition(this, parentActivity, activityName, startEventAdditionalFields, finishEventAdditionalFields);
    }

    public static /* synthetic */ IdeActivityDefinition registerIdeActivity$default(EventLogGroup eventLogGroup, String string, EventField[] eventFieldArray, EventField[] eventFieldArray2, IdeActivityDefinition ideActivityDefinition, int n, Object object) {
        boolean $i$f$emptyArray;
        if ((n & 2) != 0) {
            $i$f$emptyArray = false;
            eventFieldArray = new EventField[]{};
        }
        if ((n & 4) != 0) {
            $i$f$emptyArray = false;
            eventFieldArray2 = new EventField[]{};
        }
        if ((n & 8) != 0) {
            ideActivityDefinition = null;
        }
        return eventLogGroup.registerIdeActivity(string, eventFieldArray, eventFieldArray2, ideActivityDefinition);
    }

    public final void validateEventId$intellij_platform_statistics(@NotNull String eventId) {
        if (!this.isEventIdValid(eventId)) {
            throw new IllegalArgumentException("Trying to report unregistered event ID " + eventId + " to group " + this.id);
        }
    }

    private final boolean isEventIdValid(String eventId) {
        if (EventLogSystemEvents.SYSTEM_EVENTS.contains(eventId)) {
            return true;
        }
        return this.registeredEventIds.isEmpty() || this.registeredEventIds.contains(eventId);
    }

    @JvmOverloads
    public EventLogGroup(@NotNull String id, int version) {
        this(id, version, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IdeActivityDefinition registerIdeActivity(@Nullable String activityName, @NotNull EventField<?>[] startEventAdditionalFields, @NotNull EventField<?>[] finishEventAdditionalFields) {
        return EventLogGroup.registerIdeActivity$default(this, activityName, startEventAdditionalFields, finishEventAdditionalFields, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final IdeActivityDefinition registerIdeActivity(@Nullable String activityName, @NotNull EventField<?>[] startEventAdditionalFields) {
        return EventLogGroup.registerIdeActivity$default(this, activityName, startEventAdditionalFields, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final IdeActivityDefinition registerIdeActivity(@Nullable String activityName) {
        return EventLogGroup.registerIdeActivity$default(this, activityName, null, null, null, 14, null);
    }
}

