/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.config.bean;

import com.intellij.internal.statistic.config.eventLog.EventLogMajorVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMajorVersionBorders {
    @Nullable
    public String from;
    @Nullable
    public String to;

    public boolean accept(@NotNull String current) {
        EventLogMajorVersion build2 = EventLogMajorVersion.fromString(current);
        if (!EventLogMajorVersionBorders.isValidMajorVersion(build2)) {
            return false;
        }
        EventLogMajorVersion toVersion = EventLogMajorVersion.fromString(this.to);
        EventLogMajorVersion fromVersion = EventLogMajorVersion.fromString(this.from);
        if (!EventLogMajorVersionBorders.isValidMajorVersion(toVersion) && !EventLogMajorVersionBorders.isValidMajorVersion(fromVersion)) {
            return false;
        }
        return !(fromVersion != null && fromVersion.compareTo(build2) > 0 || toVersion != null && toVersion.compareTo(build2) <= 0);
    }

    private static boolean isValidMajorVersion(@Nullable EventLogMajorVersion build2) {
        if (build2 == null) {
            return false;
        }
        int[] components = build2.getComponents();
        return components.length > 0 && components[0] > 0;
    }
}

