/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.starters;

import com.intellij.ide.starters.StarterModuleImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/starters/GradleStarterModuleImporter;", "Lcom/intellij/ide/starters/StarterModuleImporter;", "()V", "id", "", "getId", "()Ljava/lang/String;", "title", "getTitle", "findGradleFile", "Ljava/io/File;", "module", "Lcom/intellij/openapi/module/Module;", "fixGradlewExecutableFlag", "", "containingDir", "runAfterSetup", "", "intellij.gradle.java"})
public final class GradleStarterModuleImporter
implements StarterModuleImporter {
    @NotNull
    private final String id;
    @NotNull
    private final String title;

    public GradleStarterModuleImporter() {
        this.id = "gradle";
        this.title = "Gradle";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public boolean runAfterSetup(@NotNull Module module) {
        Project project = module.getProject();
        File file = this.findGradleFile(module);
        if (file == null) {
            return true;
        }
        File gradleFile = file;
        String rootDirectory = gradleFile.getParent();
        this.fixGradlewExecutableFlag(gradleFile.getParentFile());
        if (!GradleProjectImportUtil.canLinkAndRefreshGradleProject$default((String)rootDirectory, (Project)project, (boolean)false, (int)4, null)) {
            return false;
        }
        GradleProjectImportUtil.linkAndRefreshGradleProject((String)rootDirectory, (Project)project);
        return false;
    }

    private final File findGradleFile(Module module) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
            File file = new File(baseDir, "build.gradle");
            if (file.exists()) {
                return file;
            }
            file = new File(baseDir, "build.gradle.kts");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private final void fixGradlewExecutableFlag(File containingDir) {
        File toFix = new File(containingDir, "gradlew");
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }
}

