/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0010H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0003H\u0002\u00a8\u0006\u0017"}, d2={"checkTaskCall", "", "methodCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "findMethodCallByFirstArgument", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "hasTaskIdCallArguments", "isFakeInner", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "isFakeTopTaskCall", "isFirstArgumentOfTaskMethod", "isTaskIdCall", "isTaskIdCallDown", "isTaskIdExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "isTaskIdInOperator", "isTaskIdInvoked", "isTaskIdOperatorDown", "isTopTaskCall", "isDynamicVariable", "isDynamicVariableInvoked", "intellij.gradle.java"})
public final class TaskDeclarationKt {
    private static final boolean isFakeInner(GroovyPsiElement element) {
        GroovyPsiElement groovyPsiElement = element;
        return groovyPsiElement instanceof GrMethodCall ? TaskDeclarationKt.isFakeTopTaskCall((GrMethodCall)element) || TaskDeclarationKt.isTaskIdCall((GrMethodCall)element) : (groovyPsiElement instanceof GrReferenceExpression ? TaskDeclarationKt.isTaskIdExpression((GrReferenceExpression)element) || TaskDeclarationKt.isTaskIdInvoked((GrReferenceExpression)element) || TaskDeclarationKt.isTaskIdInOperator((GrReferenceExpression)element) : false);
    }

    private static final boolean isFakeTopTaskCall(GrMethodCall methodCall) {
        if (!TaskDeclarationKt.checkTaskCall(methodCall)) {
            return false;
        }
        if (!(methodCall.getNamedArguments().length == 0)) {
            return false;
        }
        if (methodCall.hasClosureArguments()) {
            return false;
        }
        GrExpression grExpression = (GrExpression)ArraysKt.singleOrNull((Object[])methodCall.getExpressionArguments());
        if (grExpression == null) {
            return false;
        }
        GrExpression singleArgument = grExpression;
        return TaskDeclarationKt.isTaskIdCallDown(singleArgument) || TaskDeclarationKt.isTaskIdOperatorDown(singleArgument);
    }

    private static final boolean isTaskIdCall(GrMethodCall methodCall) {
        return TaskDeclarationKt.isFirstArgumentOfTaskMethod((GrExpression)methodCall) && TaskDeclarationKt.isTaskIdCallDown((GrExpression)methodCall);
    }

    private static final boolean isTaskIdCallDown(GrExpression expression) {
        return expression instanceof GrMethodCall && TaskDeclarationKt.hasTaskIdCallArguments((GrMethodCall)expression) && TaskDeclarationKt.isDynamicVariableInvoked((GrMethodCall)expression);
    }

    private static final boolean hasTaskIdCallArguments(GrMethodCall expression) {
        GrExpression[] expressions = (GrExpression[])ArraysKt.plus((Object[])expression.getExpressionArguments(), (Object[])expression.getClosureArguments());
        return switch (expressions.length) {
            case 0 -> true;
            case 1 -> expressions[0] instanceof GrClosableBlock;
            case 2 -> {
                GrExpression first = expressions[0];
                GrExpression second = expressions[1];
                if (first instanceof GrListOrMap && ((GrListOrMap)first).isMap() && second instanceof GrClosableBlock && expression.getNamedArguments().length == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final boolean isTaskIdOperatorDown(GrExpression expression) {
        if (!(expression instanceof GrBinaryExpression)) {
            return false;
        }
        GrExpression left = ((GrBinaryExpression)expression).getLeftOperand();
        return left instanceof GrLiteral || left instanceof GrReferenceExpression && !((GrReferenceExpression)left).isQualified();
    }

    private static final boolean isTopTaskCall(GrMethodCall methodCall) {
        if (!TaskDeclarationKt.checkTaskCall(methodCall)) {
            return false;
        }
        GrExpression[] expressions = methodCall.getExpressionArguments();
        int expressionsCount = expressions.length;
        if (expressionsCount == 0) {
            return false;
        }
        int argsCount = expressionsCount + methodCall.getClosureArguments().length + (methodCall.getNamedArguments().length == 0 ? 0 : 1);
        if (argsCount > 3) {
            return false;
        }
        GrExpression grExpression = expressions[0];
        GrReferenceExpression grReferenceExpression = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
        if (grReferenceExpression == null) {
            return false;
        }
        GrReferenceExpression taskId = grReferenceExpression;
        return TaskDeclarationKt.isDynamicVariable(taskId);
    }

    private static final boolean isTaskIdExpression(GrReferenceExpression expression) {
        GrMethodCall grMethodCall = TaskDeclarationKt.findMethodCallByFirstArgument((GrExpression)expression);
        if (grMethodCall == null) {
            return false;
        }
        GrMethodCall methodCall = grMethodCall;
        return TaskDeclarationKt.isTopTaskCall(methodCall);
    }

    private static final boolean isTaskIdInvoked(GrReferenceExpression expression) {
        PsiElement psiElement = expression.getParent();
        GrMethodCall grMethodCall = psiElement instanceof GrMethodCall ? (GrMethodCall)psiElement : null;
        if (grMethodCall == null) {
            return false;
        }
        GrMethodCall methodCall = grMethodCall;
        return Intrinsics.areEqual((Object)methodCall.getInvokedExpression(), (Object)expression) && TaskDeclarationKt.isTaskIdCall(methodCall);
    }

    private static final boolean isTaskIdInOperator(GrReferenceExpression expression) {
        if (expression.isQualified()) {
            return false;
        }
        PsiElement psiElement = expression.getParent();
        GrBinaryExpression grBinaryExpression = psiElement instanceof GrBinaryExpression ? (GrBinaryExpression)psiElement : null;
        if (grBinaryExpression == null) {
            return false;
        }
        GrBinaryExpression binary = grBinaryExpression;
        if (!Intrinsics.areEqual((Object)expression, (Object)binary.getLeftOperand())) {
            return false;
        }
        return TaskDeclarationKt.isFirstArgumentOfTaskMethod((GrExpression)binary);
    }

    private static final boolean isFirstArgumentOfTaskMethod(GrExpression expression) {
        GrMethodCall grMethodCall = TaskDeclarationKt.findMethodCallByFirstArgument(expression);
        if (grMethodCall == null) {
            return false;
        }
        GrMethodCall methodCall = grMethodCall;
        return TaskDeclarationKt.checkTaskCall(methodCall);
    }

    private static final GrMethodCall findMethodCallByFirstArgument(GrExpression expression) {
        PsiElement psiElement = expression.getParent();
        GrArgumentList grArgumentList = psiElement instanceof GrArgumentList ? (GrArgumentList)psiElement : null;
        if (grArgumentList == null) {
            return null;
        }
        GrArgumentList argumentList = grArgumentList;
        if (!Intrinsics.areEqual((Object)expression, (Object)argumentList.getExpressionArguments()[0])) {
            return null;
        }
        PsiElement psiElement2 = argumentList.getParent();
        return psiElement2 instanceof GrMethodCall ? (GrMethodCall)psiElement2 : null;
    }

    private static final boolean checkTaskCall(GrMethodCall methodCall) {
        GrExpression grExpression = methodCall.getInvokedExpression();
        GrReferenceExpression grReferenceExpression = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
        if (grReferenceExpression == null) {
            return false;
        }
        GrReferenceExpression invokedExpression = grReferenceExpression;
        return Intrinsics.areEqual((Object)invokedExpression.getReferenceName(), (Object)"task") && !invokedExpression.isQualified();
    }

    private static final boolean isDynamicVariableInvoked(GrMethodCall $this$isDynamicVariableInvoked) {
        GrExpression invoked = $this$isDynamicVariableInvoked.getInvokedExpression();
        return invoked instanceof GrReferenceExpression && TaskDeclarationKt.isDynamicVariable((GrReferenceExpression)invoked);
    }

    private static final boolean isDynamicVariable(GrReferenceExpression $this$isDynamicVariable) {
        return !$this$isDynamicVariable.isQualified() && $this$isDynamicVariable.getStaticReference().resolve() == null;
    }

    public static final /* synthetic */ boolean access$isFakeInner(GroovyPsiElement element) {
        return TaskDeclarationKt.isFakeInner(element);
    }

    public static final /* synthetic */ boolean access$isTaskIdExpression(GrReferenceExpression expression) {
        return TaskDeclarationKt.isTaskIdExpression(expression);
    }

    public static final /* synthetic */ boolean access$isTaskIdInOperator(GrReferenceExpression expression) {
        return TaskDeclarationKt.isTaskIdInOperator(expression);
    }

    public static final /* synthetic */ boolean access$isTaskIdCall(GrMethodCall methodCall) {
        return TaskDeclarationKt.isTaskIdCall(methodCall);
    }
}

