/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrMethodWrapper;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleSetterAsMethodContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "SetterAsMethodProcessor", "intellij.gradle.java"})
public final class GradleSetterAsMethodContributor
extends NonCodeMembersContributor {
    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        String string;
        if (aClass == null) {
            return;
        }
        if (!ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor)) {
            return;
        }
        if (!UtilKt.isGradleScript(place.getContainingFile())) {
            return;
        }
        String string2 = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = "set" + StringsKt.capitalize((String)it);
        } else {
            string = null;
        }
        String setterName = string;
        aClass.processDeclarations((PsiScopeProcessor)new SetterAsMethodProcessor(setterName, processor), state, null, place);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleSetterAsMethodContributor$SetterAsMethodProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "setterName", "", "delegate", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "(Ljava/lang/String;Lcom/intellij/psi/scope/PsiScopeProcessor;)V", "execute", "", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "extractPropertyName", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.gradle.java"})
    private static final class SetterAsMethodProcessor
    extends ProcessorWithHints {
        @NotNull
        private final PsiScopeProcessor delegate;

        public SetterAsMethodProcessor(@Nullable String setterName, @NotNull PsiScopeProcessor delegate) {
            this.delegate = delegate;
            if (setterName != null) {
                this.hint(NameHint.KEY, arg_0 -> SetterAsMethodProcessor._init_$lambda$0(setterName, arg_0));
            }
            this.hint(ElementClassHint.KEY, SetterAsMethodProcessor::_init_$lambda$1);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod psiMethod = element instanceof PsiMethod ? (PsiMethod)element : null;
            if (psiMethod == null) {
                return true;
            }
            PsiMethod method = psiMethod;
            String string = this.extractPropertyName(method);
            if (string == null) {
                return true;
            }
            String propertyName = string;
            return this.delegate.execute((PsiElement)GrMethodWrapper.wrap((PsiMethod)method, (String)propertyName), state);
        }

        private final String extractPropertyName(PsiMethod method) {
            String methodName = method.getName();
            if (!StringsKt.startsWith$default((String)methodName, (String)PropertyKind.SETTER.prefix, (boolean)false, (int)2, null)) {
                return null;
            }
            return StringKt.nullize$default((String)StringsKt.decapitalize((String)StringsKt.removePrefix((String)methodName, (CharSequence)PropertyKind.SETTER.prefix)), (boolean)false, (int)1, null);
        }

        private static final String _init_$lambda$0(String $setterName, ResolveState it) {
            return $setterName;
        }

        private static final boolean _init_$lambda$1(ElementClassHint.DeclarationKind it) {
            return it == ElementClassHint.DeclarationKind.METHOD;
        }
    }
}

