/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class GradleScriptContributor
extends NonCodeMembersContributor {
    public static final Set<String> BUILD_PROJECT_SCRIPT_BLOCKS = ContainerUtil.newHashSet((Object[])new String[]{"project", "configure", "subprojects", "allprojects", "buildscript"});

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (!UtilKt.isResolvedInGradleScript(aClass)) {
            return;
        }
        ArrayList<String> methodInfo = new ArrayList<String>();
        GrMethodCall current = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        while (current != null) {
            GrExpression expression = current.getInvokedExpression();
            String text = expression.getText();
            if (text != null) {
                methodInfo.add(text);
            }
            current = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)current, GrMethodCall.class);
        }
        String methodCall = (String)ContainerUtil.getLastItem(methodInfo);
        if (methodInfo.size() > 1 && BUILD_PROJECT_SCRIPT_BLOCKS.contains(methodCall)) {
            methodInfo.remove(methodInfo.size() - 1);
        }
        for (GradleMethodContextContributor contributor : (GradleMethodContextContributor[])GradleMethodContextContributor.EP_NAME.getExtensions()) {
            if (contributor.process(methodInfo, processor, state, place)) continue;
            return;
        }
    }
}

