/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionType;
import org.jetbrains.plugins.gradle.service.resolve.GradleExtensionsContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0014J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectExtensionContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "createType", "Lcom/intellij/psi/PsiType;", "factory", "Lcom/intellij/psi/PsiElementFactory;", "generifiedFqnClassName", "", "resolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getParentClassName", "processDynamicElements", "", "qualifierType", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "shouldAddConfiguration", "", "extension", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtension;", "context", "intellij.gradle.java"})
public final class GradleProjectExtensionContributor
extends NonCodeMembersContributor {
    @NotNull
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection extensions;
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        boolean processMethods = ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor);
        boolean processProperties = ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor);
        if (!processMethods && !processProperties) {
            return;
        }
        PsiFile containingFile = place.getContainingFile();
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = GradleExtensionsContributor.Companion.getExtensionsFor((PsiElement)containingFile);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData extensionsData = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Map allExtensions = extensionsData.extensions;
        String string = name;
        if (string == null) {
            v2 = allExtensions.values();
        } else {
            GradleExtensionsSettings.GradleExtension gradleExtension = (GradleExtensionsSettings.GradleExtension)allExtensions.get(string);
            if (gradleExtension == null) {
                return;
            }
            v2 = extensions = (Collection)CollectionsKt.listOf((Object)gradleExtension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)containingFile.getProject());
        PsiManager manager = containingFile.getManager();
        for (GradleExtensionsSettings.GradleExtension extension : extensions) {
            GrLightMethodBuilder grLightMethodBuilder;
            GradleExtensionProperty extensionProperty;
            PsiType delegateType = this.createType(factory, extension.rootTypeFqn, place.getResolveScope());
            if (!(delegateType instanceof PsiClassType)) continue;
            GradleExtensionType type = new GradleExtensionType(UtilKt.decoratePsiClassType((PsiClassType)delegateType));
            if (processProperties && !processor.execute((PsiElement)(extensionProperty = new GradleExtensionProperty(extension.name, (PsiType)type, (PsiElement)containingFile)), state)) {
                return;
            }
            if (!processMethods || !this.shouldAddConfiguration(extension, place)) continue;
            GrLightMethodBuilder $this$processDynamicElements_u24lambda_u240 = grLightMethodBuilder = new GrLightMethodBuilder(manager, extension.name);
            boolean bl = false;
            $this$processDynamicElements_u24lambda_u240.setReturnType((PsiType)type);
            $this$processDynamicElements_u24lambda_u240.setContainingClass(aClass);
            $this$processDynamicElements_u24lambda_u240.addAndGetParameter("configuration", (PsiType)TypesUtil.createType((String)"groovy.lang.Closure", (PsiElement)((PsiElement)containingFile))).putUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY, (Object)new DelegatesToInfo((PsiType)type, 1));
            GrLightMethodBuilder extensionMethod = grLightMethodBuilder;
            if (processor.execute((PsiElement)extensionMethod, state)) continue;
            return;
        }
    }

    private final boolean shouldAddConfiguration(GradleExtensionsSettings.GradleExtension extension, PsiElement context) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extension.rootTypeFqn, context.getResolveScope());
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        return !InheritanceUtil.isInheritor((PsiClass)clazz, (String)"org.gradle.api.internal.catalog.AbstractExternalDependencyFactory");
    }

    /*
     * WARNING - void declaration
     */
    private final PsiType createType(PsiElementFactory factory, String generifiedFqnClassName, GlobalSearchScope resolveScope) {
        void $this$mapTo$iv$iv;
        String className = StringsKt.substringBefore$default((String)generifiedFqnClassName, (char)'<', null, (int)2, null);
        PsiClassType hostClassType = factory.createTypeByFQClassName(className, resolveScope);
        PsiClass psiClass = hostClassType.resolve();
        if (psiClass == null) {
            return (PsiType)hostClassType;
        }
        PsiClass hostClass = psiClass;
        List parameters = new ArrayList();
        StringBuilder builder = new StringBuilder();
        int parameterStack = 1;
        String string = StringsKt.substringAfter$default((String)generifiedFqnClassName, (char)'<', null, (int)2, null);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                ++parameterStack;
                continue;
            }
            if (c == '>') {
                if (--parameterStack != 0) continue;
                parameters.add(((Object)StringsKt.trim((CharSequence)builder.toString())).toString());
                continue;
            }
            if (c == ',') {
                if (parameterStack == 0) {
                    parameters.add(builder.toString());
                    StringsKt.clear((StringBuilder)builder);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable c = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createType(factory, (String)it, resolveScope));
        }
        List parsedParameters = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = parsedParameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        return (PsiType)factory.createType(hostClass, Arrays.copyOf(psiTypeArray, psiTypeArray.length));
    }
}

