/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleGroovyProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getClassNames", "", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "processPropertiesFromFile", "", "Companion", "intellij.gradle.java"})
public final class GradleExtensionsContributor
extends NonCodeMembersContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROPERTIES_FILE_ORIGINAL_INFO = "by gradle.properties";

    @NotNull
    protected Collection<String> getClassNames() {
        Object[] objectArray = new String[]{"org.gradle.api.plugins.ExtraPropertiesExtension", "org.gradle.api.Project"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (!(qualifierType instanceof GradleProjectAwareType) && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"org.gradle.api.plugins.ExtraPropertiesExtension")) {
            return;
        }
        if (!ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor)) {
            return;
        }
        PsiFile file = place.getContainingFile();
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = Companion.getExtensionsFor((PsiElement)file);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData data = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Set<String> resolvedProperties = this.processPropertiesFromFile(aClass, processor, place, state);
        String string = name;
        Collection properties = string == null ? data.findAllProperties() : (Collection)CollectionsKt.listOfNotNull((Object)data.findProperty(string));
        for (GradleExtensionsSettings.GradleProp property : properties) {
            if (resolvedProperties.contains(property.name) || processor.execute((PsiElement)new GradleGroovyProperty(property.name, property.typeFqn, property.value, (PsiElement)file), state)) continue;
            return;
        }
    }

    private final Set<String> processPropertiesFromFile(PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (aClass == null) {
            return SetsKt.emptySet();
        }
        JavaPsiFacade factory = JavaPsiFacade.getInstance((Project)place.getProject());
        PsiClass psiClass = factory.findClass("java.lang.String", place.getResolveScope());
        if (psiClass == null || (psiClass = InferenceKt.type((PsiClass)psiClass)) == null) {
            return SetsKt.emptySet();
        }
        PsiClass stringType = psiClass;
        Sequence<PropertiesFile> properties = UtilKt.gradlePropertiesStream(place);
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Set processedNames = new LinkedHashSet();
        for (PropertiesFile propertyFile : properties) {
            if (name == null) {
                for (IProperty property : propertyFile.getProperties()) {
                    if (StringsKt.contains$default((CharSequence)property.getName(), (CharSequence)".", (boolean)false, (int)2, null)) continue;
                    processedNames.add(property.getName());
                    GrLightField newProperty = GradleExtensionsContributor.Companion.createGroovyProperty(aClass, property, (PsiClassType)stringType);
                    processor.execute((PsiElement)newProperty, state);
                }
                continue;
            }
            IProperty iProperty = propertyFile.findPropertyByKey(name);
            if (iProperty == null) continue;
            IProperty property = iProperty;
            GrLightField newProperty = GradleExtensionsContributor.Companion.createGroovyProperty(aClass, property, (PsiClassType)stringType);
            processor.execute((PsiElement)newProperty, state);
            return SetsKt.setOf((Object)newProperty.getName());
        }
        return processedNames;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion;", "", "()V", "PROPERTIES_FILE_ORIGINAL_INFO", "", "createGroovyProperty", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightField;", "aClass", "Lcom/intellij/psi/PsiClass;", "property", "Lcom/intellij/lang/properties/IProperty;", "stringType", "Lcom/intellij/psi/PsiClassType;", "getExtensionsFor", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        private final GrLightField createGroovyProperty(PsiClass aClass, IProperty property, PsiClassType stringType) {
            GrLightField newProperty = new GrLightField(aClass, property.getName(), (PsiType)stringType, property.getPsiElement());
            newProperty.setIcon(AllIcons.FileTypes.Properties);
            newProperty.setOriginInfo(GradleExtensionsContributor.PROPERTIES_FILE_ORIGINAL_INFO);
            return newProperty;
        }

        @Nullable
        public final GradleExtensionsSettings.GradleExtensionsData getExtensionsFor(@NotNull PsiElement psiElement) {
            Project project = psiElement.getProject();
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return null;
            }
            PsiFile virtualFile = psiFile;
            Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile((VirtualFile)virtualFile);
            return GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

