/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.MavenizedStructureWizardStep;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ui.DataView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.layout.ValidationInfoBuilder;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.AbstractGradleModuleBuilder;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep;", "Lcom/intellij/openapi/externalSystem/service/project/wizard/MavenizedStructureWizardStep;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "builder", "Lorg/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "(Lorg/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder;Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "_init", "", "createView", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep$GradleDataView;", "data", "findAllParents", "", "getBuilderId", "", "getHelpId", "getModuleFileDirectory", "getModuleFilePath", "updateProjectData", "validateArtifactId", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "validateGroupId", "validateName", "validateNameAndArtifactId", "validateVersion", "GradleDataView", "intellij.gradle.java"})
public final class GradleStructureWizardStep
extends MavenizedStructureWizardStep<ProjectData> {
    @NotNull
    private final AbstractGradleModuleBuilder builder;

    public GradleStructureWizardStep(@NotNull AbstractGradleModuleBuilder builder, @NotNull WizardContext context) {
        super(context);
        this.builder = builder;
    }

    @NotNull
    public String getHelpId() {
        return "Gradle_Archetype_Dialog";
    }

    @Nullable
    protected String getBuilderId() {
        return this.builder.getBuilderId();
    }

    @NotNull
    public GradleDataView createView(@NotNull ProjectData data) {
        return new GradleDataView(data);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectData> findAllParents() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Project project = this.getContext().getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Iterable $this$mapNotNull$iv = ProjectDataManager.getInstance().getExternalProjectsData(project2, GradleConstants.SYSTEM_ID);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        DataNode dataNode = $this$forEach$iv$iv$iv.iterator();
        while (dataNode.hasNext()) {
            DataNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = dataNode.next();
            boolean bl = false;
            ExternalProjectInfo it = (ExternalProjectInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getExternalProjectStructure() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            dataNode = (DataNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ProjectData)it.getData());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected ValidationInfo validateGroupId(@NotNull ValidationInfoBuilder $this$validateGroupId) {
        return null;
    }

    @Nullable
    protected ValidationInfo validateVersion(@NotNull ValidationInfoBuilder $this$validateVersion) {
        return null;
    }

    @Nullable
    protected ValidationInfo validateName(@NotNull ValidationInfoBuilder $this$validateName) {
        ValidationInfo validationInfo = this.validateNameAndArtifactId($this$validateName);
        if (validationInfo == null) {
            validationInfo = this.superValidateName($this$validateName);
        }
        return validationInfo;
    }

    @Nullable
    protected ValidationInfo validateArtifactId(@NotNull ValidationInfoBuilder $this$validateArtifactId) {
        ValidationInfo validationInfo = this.validateNameAndArtifactId($this$validateArtifactId);
        if (validationInfo == null) {
            validationInfo = this.superValidateArtifactId($this$validateArtifactId);
        }
        return validationInfo;
    }

    private final ValidationInfo validateNameAndArtifactId(ValidationInfoBuilder $this$validateNameAndArtifactId) {
        if (Intrinsics.areEqual((Object)this.getArtifactId(), (Object)this.getEntityName())) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getContext().isCreatingNewProject() ? 1 : 0};
        return $this$validateNameAndArtifactId.error(ExternalSystemBundle.message((String)"external.system.mavenized.structure.wizard.name.and.artifact.id.is.different.error", (Object[])objectArray));
    }

    public void updateProjectData() {
        this.getContext().setProjectBuilder((ProjectBuilder)this.builder);
        this.builder.setParentProject((ProjectData)this.getParentData());
        this.builder.setProjectId(new ProjectId(this.getGroupId(), this.getArtifactId(), this.getVersion()));
        ProjectData projectData = (ProjectData)this.getParentData();
        this.builder.setInheritGroupId(Intrinsics.areEqual((Object)(projectData != null ? projectData.getGroup() : null), (Object)this.getGroupId()));
        ProjectData projectData2 = (ProjectData)this.getParentData();
        this.builder.setInheritVersion(Intrinsics.areEqual((Object)(projectData2 != null ? projectData2.getVersion() : null), (Object)this.getVersion()));
        this.builder.setName(this.getEntityName());
        this.builder.setContentEntryPath(this.getLocation());
        this.builder.setModuleFilePath(this.getModuleFilePath());
        this.builder.setCreatingNewProject(this.getContext().isCreatingNewProject());
        Sdk sdk = this.builder.getModuleJdk();
        if (sdk == null) {
            sdk = AbstractProjectWizard.getNewProjectJdk((WizardContext)this.getContext());
        }
        this.builder.setModuleJdk(sdk);
    }

    private final String getModuleFilePath() {
        String moduleFileDirectory = this.getModuleFileDirectory();
        String[] stringArray = new String[]{moduleFileDirectory, this.getArtifactId() + ".iml"};
        String moduleFilePath = FileUtil.join((String[])stringArray);
        return FileUtil.toCanonicalPath((String)moduleFilePath);
    }

    private final String getModuleFileDirectory() {
        Object object = this.getContext().getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = this.getLocation();
        }
        Object projectPath = object;
        StorageScheme storageScheme = this.getContext().getProjectStorageFormat();
        return switch (storageScheme == null ? -1 : WhenMappings.$EnumSwitchMapping$0[storageScheme.ordinal()]) {
            case 1 -> this.getLocation();
            case 2 -> {
                String[] var2_2 = new String[]{projectPath, ".idea", "modules"};
                yield FileUtil.join((String[])var2_2);
            }
            default -> projectPath;
        };
    }

    public void _init() {
        block4: {
            String it;
            String string = this.builder.getName();
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                this.setEntityName(it2);
            }
            ProjectId projectId = this.builder.getProjectId();
            if (projectId == null) break block4;
            ProjectId projectId2 = projectId;
            boolean bl = false;
            String string2 = projectId2.getGroupId();
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                this.setGroupId(it);
            }
            String string3 = projectId2.getArtifactId();
            if (string3 != null) {
                it = string3;
                boolean bl3 = false;
                this.setArtifactId(it);
            }
            String string4 = projectId2.getVersion();
            if (string4 != null) {
                it = string4;
                boolean bl4 = false;
                this.setVersion(it);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep$GradleDataView;", "Lcom/intellij/openapi/externalSystem/util/ui/DataView;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "data", "(Lcom/intellij/openapi/externalSystem/model/project/ProjectData;)V", "getData", "()Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "groupId", "", "getGroupId", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "location", "getLocation", "presentationName", "getPresentationName", "version", "getVersion", "intellij.gradle.java"})
    public static final class GradleDataView
    extends DataView<ProjectData> {
        @NotNull
        private final ProjectData data;
        @NotNull
        private final String location;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String presentationName;
        @NotNull
        private final String groupId;
        @NotNull
        private final String version;

        public GradleDataView(@NotNull ProjectData data) {
            String string;
            this.data = data;
            this.location = this.getData().getLinkedExternalProjectPath();
            this.icon = GradleIcons.GradleFile;
            this.presentationName = this.getData().getExternalName();
            String string2 = this.getData().getGroup();
            if (string2 == null) {
                string2 = this.groupId = "";
            }
            if ((string = this.getData().getVersion()) == null) {
                string = "";
            }
            this.version = string;
        }

        @NotNull
        public ProjectData getData() {
            return this.data;
        }

        @NotNull
        public String getLocation() {
            return this.location;
        }

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public String getPresentationName() {
            return this.presentationName;
        }

        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageScheme.values().length];
            try {
                nArray[StorageScheme.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageScheme.DIRECTORY_BASED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

