/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportBuilder;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import icons.GradleIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Deprecated
public final class GradleProjectImportBuilder
extends AbstractExternalProjectImportBuilder<ImportFromGradleControl> {
    private static final Logger LOG = Logger.getInstance(GradleProjectImportBuilder.class);
    private static GradleProjectImportBuilder ourInstance = null;

    public GradleProjectImportBuilder() {
        this(ProjectDataManager.getInstance());
    }

    public GradleProjectImportBuilder(@NotNull ProjectDataManager dataManager) {
        super(dataManager, () -> new ImportFromGradleControl(), GradleConstants.SYSTEM_ID);
        LOG.warn("Do not use `GradleProjectImportBuilder` directly. Use instead:\nInternal stable Api\n Use `com.intellij.ide.actions.ImportModuleAction.doImport` to import (attach) a new project.\n Use `com.intellij.ide.impl.ProjectUtil.openOrImport` to open (import) a new project.\nInternal experimental Api\n Use `org.jetbrains.plugins.gradle.service.project.open.openGradleProject` to open (import) a new gradle project.\n Use `org.jetbrains.plugins.gradle.service.project.open.linkAndRefreshGradleProject` to link a gradle project to an opened idea project.", new Throwable());
    }

    @NotNull
    public String getName() {
        return GradleBundle.message((String)"gradle.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    @Nullable
    protected Sdk resolveProjectJdk(@NotNull WizardContext context) {
        JavaSdk javaSdkType = JavaSdk.getInstance();
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        Predicate<Sdk> sdkCondition = sdk -> {
            JavaSdkVersion v = javaSdkType.getVersion(sdk);
            return v != null && v.isAtLeast(JavaSdkVersion.JDK_1_6) && !v.isAtLeast(JavaSdkVersion.JDK_1_9) && ExternalSystemJdkUtil.isValidJdk((Sdk)sdk);
        };
        Sdk mostRecentSdk = jdkTable.getSdksOfType((SdkTypeId)javaSdkType).stream().filter(sdkCondition).max(javaSdkType.versionComparator()).orElse(null);
        if (mostRecentSdk != null) {
            return mostRecentSdk;
        }
        Set existingPaths = Arrays.stream(jdkTable.getAllJdks()).map(sdk -> sdk.getHomePath()).collect(Collectors.toCollection(() -> CollectionFactory.createFilePathSet()));
        for (String javaHome : javaSdkType.suggestHomePaths()) {
            Sdk jdk;
            if (existingPaths.contains(FileUtil.toCanonicalPath((String)javaHome)) || !sdkCondition.test(jdk = javaSdkType.createJdk((String)ObjectUtils.notNull((Object)javaSdkType.suggestSdkName(null, javaHome), (Object)""), javaHome))) continue;
            ApplicationManager.getApplication().runWriteAction(() -> jdkTable.addJdk(jdk));
            return jdk;
        }
        Project project = context.getProject() != null ? context.getProject() : ProjectManager.getInstance().getDefaultProject();
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
        if (!"#JAVA_INTERNAL".equals(sdkPair.first)) {
            return (Sdk)sdkPair.second;
        }
        return null;
    }

    protected void doPrepare(@NotNull WizardContext context) {
        String pathToUse = this.getFileToImport();
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(pathToUse);
        if (file != null && !file.isDirectory() && file.getParent() != null) {
            pathToUse = file.getParent().getPath();
        }
        ImportFromGradleControl importFromGradleControl = (ImportFromGradleControl)this.getControl(context.getProject());
        importFromGradleControl.setLinkedProjectPath(pathToUse);
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project, final @NotNull ExternalProjectSettings projectSettings) {
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                Runnable selectDataTask = () -> {
                    ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project, (ExternalProjectInfo)new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath(), externalProject));
                    if (dialog.hasMultipleDataToSelect()) {
                        dialog.showAndGet();
                    } else {
                        Disposer.dispose((Disposable)dialog.getDisposable());
                    }
                };
                Runnable importTask = () -> ((ProjectDataManager)ApplicationManager.getApplication().getService(ProjectDataManager.class)).importData(externalProject, project);
                boolean showSelectiveImportDialog = GradleSettings.getInstance((Project)project).showSelectiveImportDialogOnInitialImport();
                if (showSelectiveImportDialog && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        selectDataTask.run();
                        ApplicationManager.getApplication().executeOnPooledThread(importTask);
                    });
                } else {
                    importTask.run();
                }
            }
        };
    }

    protected void beforeCommit(@NotNull DataNode<ProjectData> dataNode, @NotNull Project project) {
        LanguageLevelProjectExtension languageLevelExtension;
        DataNode javaProjectNode;
        if (project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE && GradleSettings.getInstance((Project)project).getLinkedProjectsSettings().isEmpty()) {
            ExternalProjectsManagerImpl.getInstance((Project)project).setStoreExternally(true);
        }
        if ((javaProjectNode = ExternalSystemApiUtil.find(dataNode, (Key)JavaProjectData.KEY)) == null) {
            return;
        }
        LanguageLevel externalLanguageLevel = ((JavaProjectData)javaProjectNode.getData()).getLanguageLevel();
        if (externalLanguageLevel != (languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project)).getLanguageLevel()) {
            languageLevelExtension.setLanguageLevel(externalLanguageLevel);
        }
    }

    protected void applyExtraSettings(@NotNull WizardContext context) {
        DataNode node = this.getExternalProjectNode();
        if (node == null) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find((DataNode)node, (Key)JavaProjectData.KEY);
        if (javaProjectNode != null) {
            JavaProjectData data = (JavaProjectData)javaProjectNode.getData();
            context.setCompilerOutputDirectory(data.getCompileOutputPath());
            JavaSdkVersion version = data.getJdkVersion();
            Sdk jdk = JavaSdkVersionUtil.findJdkByVersion((JavaSdkVersion)version);
            if (jdk != null) {
                context.setProjectJdk(jdk);
            }
        }
    }

    @NotNull
    protected File getExternalProjectConfigToUse(@NotNull File file) {
        return file.isDirectory() ? file : file.getParentFile();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    @ApiStatus.Experimental
    static GradleProjectImportBuilder getInstance() {
        if (ourInstance == null) {
            ourInstance = new GradleProjectImportBuilder();
        }
        return ourInstance;
    }
}

