/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationSearcher;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.data.ExternalAnnotationsDataServiceKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a8\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\r2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"lookForLocations", "Lkotlin/Pair;", "Lcom/intellij/openapi/roots/libraries/Library;", "", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocation;", "project", "Lcom/intellij/openapi/project/Project;", "lib", "libData", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "resolveProvidedAnnotations", "", "providedAnnotations", "", "onResolveCompleted", "Lkotlin/Function0;", "shouldImportExternalAnnotations", "", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "intellij.gradle.java"})
public final class ExternalAnnotationsDataServiceKt {
    public static final boolean shouldImportExternalAnnotations(@Nullable ProjectData projectData, @NotNull Project project) {
        Object v0;
        block4: {
            if (projectData == null) {
                return false;
            }
            if (project.isDisposed()) {
                return false;
            }
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
            if (gradleSettings.isOfflineWork()) {
                return false;
            }
            Iterable iterable = gradleSettings.getLinkedProjectsSettings();
            for (Object t : iterable) {
                GradleProjectSettings settings = (GradleProjectSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)settings.getExternalProjectPath(), (Object)projectData.getLinkedExternalProjectPath())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        GradleProjectSettings gradleProjectSettings = v0;
        return gradleProjectSettings != null ? gradleProjectSettings.isResolveExternalAnnotations() : false;
    }

    @Nullable
    public static final Pair<Library, Collection<AnnotationsLocation>> lookForLocations(@NotNull Project project, @NotNull Library lib, @NotNull LibraryData libData) {
        Collection locations = AnnotationsLocationSearcher.Companion.findAnnotationsLocation(project, lib, libData.getArtifactId(), libData.getGroupId(), libData.getVersion());
        return locations.isEmpty() ? null : TuplesKt.to((Object)lib, (Object)locations);
    }

    /*
     * WARNING - void declaration
     */
    public static final void resolveProvidedAnnotations(@NotNull Map<Library, ? extends Collection<? extends AnnotationsLocation>> providedAnnotations, @NotNull Project project, @NotNull Function0<Unit> onResolveCompleted) {
        Set locationsToSkip = new LinkedHashSet();
        if (!providedAnnotations.isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<Library, ? extends Collection<? extends AnnotationsLocation>> $this$map$iv = providedAnnotations;
            boolean $i$f$map = false;
            Map<Library, ? extends Collection<? extends AnnotationsLocation>> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Collection)it.getValue()).size());
            }
            double total = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            String title$iv = GradleBundle.message((String)"gradle.tasks.annotations.title", (Object[])new Object[0]);
            Project project$iv = null;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, title$iv, cancellable$iv, providedAnnotations, onResolveCompleted, locationsToSkip, total, project){
                final /* synthetic */ Map $providedAnnotations$inlined;
                final /* synthetic */ Function0 $onResolveCompleted$inlined;
                final /* synthetic */ Set $locationsToSkip$inlined;
                final /* synthetic */ double $total$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$providedAnnotations$inlined = map;
                    this.$onResolveCompleted$inlined = function0;
                    this.$locationsToSkip$inlined = set;
                    this.$total$inlined = d;
                    this.$project$inlined = project;
                    super($project, $title, $cancellable);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator indicator2 = indicator;
                    boolean bl = false;
                    try {
                        indicator2.setIndeterminate(false);
                        List resolvers = ExternalAnnotationsArtifactsResolver.EP_NAME.getExtensionList();
                        int index = 0;
                        Map $this$forEach$iv = this.$providedAnnotations$inlined;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> entry = element$iv = iterator.next();
                            boolean bl2 = false;
                            Library lib = (Library)entry.getKey();
                            Collection locations = (Collection)entry.getValue();
                            Object[] objectArray = new Object[]{lib.getName()};
                            indicator2.setText(GradleBundle.message((String)"gradle.tasks.annotations.looking.for", (Object[])objectArray));
                            Iterable $this$forEach$iv2 = locations;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv2) {
                                void $this$fold$iv;
                                AnnotationsLocation location = (AnnotationsLocation)element$iv2;
                                boolean bl3 = false;
                                if (this.$locationsToSkip$inlined.contains(location)) continue;
                                Iterable iterable = resolvers;
                                boolean initial$iv = false;
                                boolean $i$f$fold = false;
                                boolean accumulator$iv = initial$iv;
                                for (T element$iv3 : $this$fold$iv) {
                                    void res;
                                    ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)element$iv3;
                                    boolean acc = accumulator$iv;
                                    boolean bl4 = false;
                                    accumulator$iv = acc || res.resolve(this.$project$inlined, lib, location);
                                }
                                if (!accumulator$iv) {
                                    this.$locationsToSkip$inlined.add(location);
                                }
                                indicator2.setFraction((double)(++index) / this.$total$inlined);
                            }
                        }
                    }
                    finally {
                        this.$onResolveCompleted$inlined.invoke();
                    }
                }
            });
        } else {
            onResolveCompleted.invoke();
        }
    }

    public static /* synthetic */ void resolveProvidedAnnotations$default(Map map, Project project, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = resolveProvidedAnnotations.1.INSTANCE;
        }
        ExternalAnnotationsDataServiceKt.resolveProvidedAnnotations(map, project, (Function0<Unit>)function0);
    }
}

