/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.CommandLineUtil;
import com.intellij.externalSystem.JavaModuleData;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.AnnotationProcessingData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaGradleProjectResolver.class);

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        this.populateJavaProjectCompilerSettings(gradleProject, ideProject);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    @NotNull
    private String getCompileOutputPath() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        return projectDirPath + "/build/classes";
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        this.populateJavaModuleCompilerSettings(gradleModule, ideModule);
        this.populateBuildScriptClasspathData(gradleModule, ideModule);
        this.populateAnnotationProcessorData(gradleModule, ideModule);
        this.populateDependenciesGraphData(gradleModule, ideModule);
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    private void populateAnnotationProcessorData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        AnnotationProcessingModel apModel = (AnnotationProcessingModel)this.resolverCtx.getExtraProject(gradleModule, AnnotationProcessingModel.class);
        if (apModel == null) {
            return;
        }
        if (!this.resolverCtx.isResolveModulePerSourceSet()) {
            AnnotationProcessingData apData = JavaGradleProjectResolver.getMergedAnnotationProcessingData(apModel);
            DataNode dataNode = ideModule.createChild(AnnotationProcessingData.KEY, (Object)apData);
            JavaGradleProjectResolver.populateAnnotationProcessingOutput((DataNode<AnnotationProcessingData>)dataNode, apModel);
        } else {
            Collection all = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            for (DataNode node : all) {
                AnnotationProcessingData apData = JavaGradleProjectResolver.getAnnotationProcessingData(apModel, ((GradleSourceSetData)node.getData()).getModuleName());
                if (apData == null) continue;
                DataNode dataNode = node.createChild(AnnotationProcessingData.KEY, (Object)apData);
                JavaGradleProjectResolver.populateAnnotationProcessorOutput((DataNode<AnnotationProcessingData>)dataNode, apModel, ((GradleSourceSetData)node.getData()).getModuleName());
            }
        }
    }

    private static void populateAnnotationProcessorOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config = apModel.bySourceSetName(sourceSetName);
        if (config != null && config.getProcessorOutput() != null) {
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    private static void populateAnnotationProcessingOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel) {
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            if (config.getProcessorOutput() == null) continue;
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    @NotNull
    private static AnnotationProcessingData getMergedAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel) {
        LinkedHashSet<String> mergedAnnotationProcessorPath = new LinkedHashSet<String>();
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            mergedAnnotationProcessorPath.addAll(config.getAnnotationProcessorPath());
        }
        ArrayList<String> apArguments = new ArrayList<String>();
        AnnotationProcessingConfig mainConfig = apModel.bySourceSetName("main");
        if (mainConfig != null) {
            apArguments.addAll(mainConfig.getAnnotationProcessorArguments());
        }
        return AnnotationProcessingData.create(mergedAnnotationProcessorPath, apArguments);
    }

    @Nullable
    private static AnnotationProcessingData getAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config = apModel.bySourceSetName(sourceSetName);
        if (config == null) {
            return null;
        }
        return AnnotationProcessingData.create(config.getAnnotationProcessorPath(), config.getAnnotationProcessorArguments());
    }

    private void populateBuildScriptClasspathData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        BuildScriptClasspathModel buildScriptClasspathModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        List classpathEntries = buildScriptClasspathModel != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> BuildScriptClasspathData.ClasspathEntry.create((Set)model.getClasses(), (Set)model.getSources(), (Set)model.getJavadoc())) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    private void populateDependenciesGraphData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectDependencies projectDependencies = (ProjectDependencies)this.resolverCtx.getExtraProject(gradleModule, ProjectDependencies.class);
        if (projectDependencies != null) {
            ideModule.createChild(ProjectKeys.DEPENDENCIES_GRAPH, (Object)projectDependencies);
        }
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        boolean testsWillBeExecuted = Boolean.parseBoolean(parameters.get("TEST_EXECUTION_EXPECTED"));
        boolean testLauncherWillBeUsed = Boolean.parseBoolean(parameters.get("TEST_LAUNCHER_WILL_BE_USED"));
        if (testsWillBeExecuted && !testLauncherWillBeUsed) {
            String name = "/org/jetbrains/plugins/gradle/java/addTestListener.groovy";
            try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(name), StandardCharsets.UTF_8);){
                initScriptConsumer.consume((Object)StreamUtil.readText((Reader)reader));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        String jvmParametersSetup = parameters.get("JVM_PARAMETERS_SETUP");
        this.enhanceTaskProcessing(taskNames, jvmParametersSetup, initScriptConsumer);
    }

    private String loadTestEventListenerDefinition() {
        String string;
        String name = "/org/jetbrains/plugins/gradle/IJTestLogger.groovy";
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(name), StandardCharsets.UTF_8);
        try {
            string = StreamUtil.readText((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return "";
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (!StringUtil.isEmpty((String)jvmParametersSetup)) {
            LOG.assertTrue(!jvmParametersSetup.contains("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address="), (Object)"Please use org.jetbrains.plugins.gradle.service.debugger.GradleJvmDebuggerBackend to setup debugger");
            String names = "[" + JavaGradleProjectResolver.toStringListLiteral(taskNames, ", ") + "]";
            List argv = ParametersListUtil.parse((String)jvmParametersSetup);
            if (SystemInfo.isWindows) {
                argv = ContainerUtil.map((Collection)argv, s -> CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false));
            }
            String jvmArgs = JavaGradleProjectResolver.toStringListLiteral(argv, " << ");
            String[] lines = new String[]{"gradle.taskGraph.whenReady { taskGraph ->", "  taskGraph.allTasks.each { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << " + jvmArgs, "        task.jvmArgs = jvmArgs", "    }", "  }", "}"};
            String script = StringUtil.join((String[])lines, (String)System.lineSeparator());
            initScriptConsumer.consume((Object)script);
        }
        String testEventListenerDefinition = this.loadTestEventListenerDefinition();
        initScriptConsumer.consume((Object)testEventListenerDefinition);
    }

    @NotNull
    private static String toStringListLiteral(@NotNull List<String> strings, @NotNull String separator) {
        List quotedStrings = ContainerUtil.map(strings, s -> StringUtil.escapeChar((String)JavaGradleProjectResolver.toStringLiteral(s), (char)'$'));
        return StringUtil.join((Collection)quotedStrings, (String)separator);
    }

    @NotNull
    private static String toStringLiteral(@NotNull String s) {
        return StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)s));
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        return ContainerUtil.set((Object[])new Class[]{AnnotationProcessingModel.class, ProjectDependencies.class});
    }

    private void populateJavaProjectCompilerSettings(@NotNull IdeaProject ideaProject, @NotNull DataNode<ProjectData> projectNode) {
        String compileOutputPath = this.getCompileOutputPath();
        LanguageLevel languageLevel = this.getLanguageLevel(ideaProject);
        String targetBytecodeVersion = this.getTargetBytecodeVersion(ideaProject);
        JavaSdkVersion jdkVersion = JavaProjectData.resolveSdkVersion((String)ideaProject.getJdkName());
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, compileOutputPath, jdkVersion, languageLevel, targetBytecodeVersion);
        projectNode.createChild(JavaProjectData.KEY, (Object)javaProjectData);
    }

    private void populateJavaModuleCompilerSettings(@NotNull IdeaModule ideaModule, @NotNull DataNode<ModuleData> moduleNode) {
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(ideaModule, ExternalProject.class);
        if (externalProject == null) {
            return;
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            Map<ExternalSourceSet, DataNode<GradleSourceSetData>> sourceSets = this.findSourceSets(ideaModule, externalProject, moduleNode);
            for (Map.Entry<ExternalSourceSet, DataNode<GradleSourceSetData>> entry : sourceSets.entrySet()) {
                JavaModuleData moduleData = JavaGradleProjectResolver.createSourceSetModuleData(ideaModule, entry.getKey());
                entry.getValue().createChild(JavaModuleData.KEY, (Object)moduleData);
            }
        }
        JavaModuleData moduleData = JavaGradleProjectResolver.createMainModuleData(ideaModule, externalProject);
        moduleNode.createChild(JavaModuleData.KEY, (Object)moduleData);
    }

    @NotNull
    private static JavaModuleData createMainModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(ideaModule, externalProject);
        String targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(ideaModule, externalProject);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion);
    }

    @NotNull
    private static JavaModuleData createSourceSetModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(ideaModule, sourceSet);
        String targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(ideaModule, sourceSet);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion);
    }

    @NotNull
    private Map<ExternalSourceSet, DataNode<GradleSourceSetData>> findSourceSets(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> moduleNode) {
        Collection sourceSetNodes = ExternalSystemApiUtil.getChildren(moduleNode, (Key)GradleSourceSetData.KEY);
        LinkedHashMap<String, DataNode> sourceSetIndex = new LinkedHashMap<String, DataNode>();
        for (DataNode sourceSetNode : sourceSetNodes) {
            sourceSetIndex.put(((GradleSourceSetData)sourceSetNode.getData()).getId(), sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> result = new LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>>();
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            String moduleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)ideaModule, (ExternalSourceSet)sourceSet);
            DataNode sourceSetNode = (DataNode)sourceSetIndex.get(moduleId);
            if (sourceSetNode == null) continue;
            result.put(sourceSet, (DataNode<GradleSourceSetData>)sourceSetNode);
        }
        return result;
    }

    @NotNull
    private List<Pair<IdeaModule, ExternalProject>> getExternalModules(@NotNull IdeaProject ideaProject) {
        return ideaProject.getModules().stream().map(it -> new Pair(it, (Object)((ExternalProject)this.resolverCtx.getExtraProject(it, ExternalProject.class)))).filter(it -> it.second != null).collect(Collectors.toList());
    }

    @Nullable
    private LanguageLevel getLanguageLevel(@NotNull IdeaProject ideaProject) {
        List<Pair<IdeaModule, ExternalProject>> externalModules = this.getExternalModules(ideaProject);
        LanguageLevel languageLevel = externalModules.stream().map(it -> JavaGradleProjectResolver.getLanguageLevel((IdeaModule)it.first, (ExternalProject)it.second)).filter(it -> it != null).min(Comparator.naturalOrder()).orElse(null);
        if (languageLevel != null) {
            return languageLevel;
        }
        boolean isPreview = ContainerUtil.and(externalModules, it -> JavaGradleProjectResolver.isPreview((ExternalProject)it.second));
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, isPreview);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        boolean isPreview = JavaGradleProjectResolver.isPreview(externalProject);
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(externalProject, isPreview);
        if (languageLevel != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, isPreview);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(sourceSet);
        if (languageLevel != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, sourceSet.isPreview());
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalSourceSet sourceSet) {
        String sourceCompatibility = sourceSet.getSourceCompatibility();
        if (sourceCompatibility == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, sourceSet.isPreview());
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalProject externalProject, boolean isPreview) {
        String sourceCompatibility = externalProject.getSourceCompatibility();
        if (sourceCompatibility == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, isPreview);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@Nullable IdeaJavaLanguageSettings languageSettings, boolean isPreview) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion languageLevel = languageSettings.getLanguageLevel();
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(languageLevel.toString(), isPreview);
    }

    @Nullable
    private static LanguageLevel parseLanguageLevel(@NotNull String languageLevelString, boolean isPreview) {
        LanguageLevel languageLevel = LanguageLevel.parse((String)languageLevelString);
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.setPreview(languageLevel, isPreview);
    }

    @NotNull
    private static LanguageLevel setPreview(@NotNull LanguageLevel languageLevel, boolean isPreview) {
        if (languageLevel.isPreview() == isPreview) {
            return languageLevel;
        }
        com.intellij.util.lang.JavaVersion javaVersion = languageLevel.toJavaVersion();
        return Arrays.stream(LanguageLevel.values()).filter(it -> it.isPreview() == isPreview).filter(it -> it.toJavaVersion().equals((Object)javaVersion)).findFirst().orElse(languageLevel);
    }

    private static boolean isPreview(@NotNull ExternalProject externalProject) {
        Collection values = externalProject.getSourceSets().values();
        if (values.isEmpty()) {
            return false;
        }
        return ContainerUtil.and(values, it -> it.isPreview());
    }

    @Nullable
    private String getTargetBytecodeVersion(@NotNull IdeaProject ideaProject) {
        String targetBytecodeVersion = this.getExternalModules(ideaProject).stream().map(it -> JavaGradleProjectResolver.getTargetBytecodeVersion((IdeaModule)it.first, (ExternalProject)it.second)).filter(it -> it != null).min(Comparator.naturalOrder()).orElse(null);
        if (targetBytecodeVersion != null) {
            return targetBytecodeVersion;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        String targetCompatibility = externalProject.getTargetCompatibility();
        if (targetCompatibility != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        String targetCompatibility = sourceSet.getTargetCompatibility();
        if (targetCompatibility != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@Nullable IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion targetByteCodeVersion = languageSettings.getTargetBytecodeVersion();
        if (targetByteCodeVersion == null) {
            return null;
        }
        return targetByteCodeVersion.toString();
    }
}

