/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.navigation;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.UtilKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.navigation.TomlHeaderKind;
import org.jetbrains.plugins.gradle.service.navigation.TomlVersionCatalogVisitor;
import org.jetbrains.plugins.gradle.service.resolve.VersionCatalogsLocator;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0001H\u0002\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"METHOD_GET_BUNDLES", "", "METHOD_GET_PLUGINS", "METHOD_GET_VERSIONS", "TOML_TABLE_BUNDLES", "TOML_TABLE_LIBRARIES", "TOML_TABLE_PLUGINS", "TOML_TABLE_VERSIONS", "findFinishingNode", "Lcom/intellij/psi/PsiMethod;", "element", "Lcom/intellij/psi/PsiElement;", "findTomlFile", "Lorg/toml/lang/psi/TomlFile;", "context", "name", "getTomlHeaderKind", "Lorg/jetbrains/plugins/gradle/service/navigation/TomlHeaderKind;", "Lcom/intellij/psi/PsiClass;", "resolveInToml", "intellij.gradle.java"})
public final class GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt {
    @NotNull
    private static final String TOML_TABLE_VERSIONS = "versions";
    @NotNull
    private static final String TOML_TABLE_LIBRARIES = "libraries";
    @NotNull
    private static final String TOML_TABLE_BUNDLES = "bundles";
    @NotNull
    private static final String TOML_TABLE_PLUGINS = "plugins";
    @NotNull
    private static final String METHOD_GET_PLUGINS = "getPlugins";
    @NotNull
    private static final String METHOD_GET_VERSIONS = "getVersions";
    @NotNull
    private static final String METHOD_GET_BUNDLES = "getBundles";

    private static final TomlFile findTomlFile(PsiElement context, String name) {
        TomlFile tomlFile;
        PsiFile psiFile;
        block10: {
            block9: {
                org.jetbrains.plugins.gradle.service.resolve.UtilKt.getRootGradleProjectPath(context);
                psiFile = context.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) break block9;
                PsiFile it = psiFile;
                boolean bl = false;
                Module module = ProjectFileIndex.getInstance((Project)context.getProject()).getModuleForFile((VirtualFile)it);
                psiFile = module;
                if (module != null) break block10;
            }
            return null;
        }
        PsiFile module = psiFile;
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<VersionCatalogsLocator> serviceClass$iv = VersionCatalogsLocator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        Path path = (Path)((VersionCatalogsLocator)object).getVersionCatalogsForModule((Module)module).get(name);
        if (path == null) {
            return null;
        }
        Path tomlPath = path;
        VirtualFile virtualFile = VfsUtil.findFile((Path)tomlPath, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile toml = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)context.getProject()).findFile(toml);
        if (psiFile2 != null) {
            PsiFile $this$asSafely$iv = psiFile2;
            boolean $i$f$asSafely = false;
            PsiFile psiFile3 = $this$asSafely$iv;
            if (!(psiFile3 instanceof TomlFile)) {
                psiFile3 = null;
            }
            tomlFile = (TomlFile)psiFile3;
        } else {
            tomlFile = null;
        }
        return tomlFile;
    }

    private static final PsiElement resolveInToml(PsiMethod $this$resolveInToml, PsiElement context) {
        TomlFile tomlFile;
        List containingClasses;
        block5: {
            Object[] objectArray = new PsiClass[1];
            if ($this$resolveInToml.getContainingClass() == null) {
                PsiClass cfr_ignored_0 = objectArray[0];
                return null;
            }
            containingClasses = CollectionsKt.mutableListOf((Object[])objectArray);
            while (((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass() != null) {
                PsiClass psiClass = ((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass);
                containingClasses.add(psiClass);
            }
            CollectionsKt.reverse((List)containingClasses);
            String string = ((PsiClass)CollectionsKt.first((List)containingClasses)).getName();
            if (string == null || (string = StringsKt.substringAfter$default((String)string, (String)"LibrariesFor", null, (int)2, null)) == null) {
                return null;
            }
            String name = string;
            Object[] objectArray2 = new String[]{GroovyPropertyUtils.decapitalize((String)name), name};
            for (String it : (Iterable)CollectionsKt.listOf((Object[])objectArray2)) {
                boolean bl = false;
                TomlFile tomlFile2 = GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.findTomlFile(context, it);
                if (tomlFile2 == null) continue;
                tomlFile = tomlFile2;
                break block5;
            }
            tomlFile = null;
        }
        if (tomlFile == null) {
            return null;
        }
        TomlFile toml = tomlFile;
        TomlVersionCatalogVisitor tomlVisitor = new TomlVersionCatalogVisitor(UtilKt.tail((List)containingClasses), $this$resolveInToml);
        toml.accept((PsiElementVisitor)tomlVisitor);
        return tomlVisitor.getResolveTarget();
    }

    private static final PsiMethod findFinishingNode(PsiElement element) {
        PsiMethod topElement = null;
        for (PsiElement ancestor : PsiTreeUtilKt.parents((PsiElement)element, (boolean)true)) {
            PsiElement resolved;
            if (!(ancestor instanceof GrReferenceElement) || !((resolved = ((GrReferenceElement)ancestor).resolve()) instanceof PsiMethod) || !StringsKt.startsWith$default((String)((PsiMethod)resolved).getContainingFile().getName(), (String)"LibrariesFor", (boolean)false, (int)2, null)) continue;
            topElement = (PsiMethod)resolved;
        }
        return topElement;
    }

    private static final TomlHeaderKind getTomlHeaderKind(PsiClass $this$getTomlHeaderKind) {
        String string = $this$getTomlHeaderKind.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"VersionAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.VERSIONS : (StringsKt.endsWith$default((String)name, (String)"BundleAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.BUNDLES : (StringsKt.endsWith$default((String)name, (String)"PluginAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.PLUGINS : (StringsKt.endsWith$default((String)name, (String)"LibraryAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.LIBRARIES : null)));
    }

    private static final TomlHeaderKind getTomlHeaderKind(String $this$getTomlHeaderKind) {
        return switch ($this$getTomlHeaderKind) {
            case TOML_TABLE_VERSIONS -> TomlHeaderKind.VERSIONS;
            case TOML_TABLE_LIBRARIES -> TomlHeaderKind.LIBRARIES;
            case TOML_TABLE_BUNDLES -> TomlHeaderKind.BUNDLES;
            case TOML_TABLE_PLUGINS -> TomlHeaderKind.PLUGINS;
            default -> null;
        };
    }

    public static final /* synthetic */ TomlFile access$findTomlFile(PsiElement context, String name) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.findTomlFile(context, name);
    }

    public static final /* synthetic */ PsiMethod access$findFinishingNode(PsiElement element) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.findFinishingNode(element);
    }

    public static final /* synthetic */ PsiElement access$resolveInToml(PsiMethod $receiver, PsiElement context) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.resolveInToml($receiver, context);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(String $receiver) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.getTomlHeaderKind($receiver);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(PsiClass $receiver) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.getTomlHeaderKind($receiver);
    }
}

