/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageDirectoryCache;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleBuildClasspathManager {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile List<VirtualFile> allFilesCache = null;
    @NotNull
    private final AtomicReference<Map<String, List<VirtualFile>>> myClasspathMap = new AtomicReference(new HashMap());
    @NotNull
    private final Map<String, PackageDirectoryCache> myClassFinderCache = ConcurrentFactoryMap.createMap(path -> PackageDirectoryCache.createCache(this.getModuleClasspathEntries((String)path)));

    public GradleBuildClasspathManager(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static GradleBuildClasspathManager getInstance(@NotNull Project project) {
        return (GradleBuildClasspathManager)project.getService(GradleBuildClasspathManager.class);
    }

    public void reload() {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
        HashMap map = new HashMap();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        HashMap<String, VirtualFile> localVFCache = new HashMap<String, VirtualFile>();
        for (ExternalProjectBuildClasspathPojo projectBuildClasspathPojo : localSettings.getProjectBuildClasspath().values()) {
            ArrayList projectBuildClasspath = new ArrayList();
            for (String path : projectBuildClasspathPojo.getProjectBuildClasspath()) {
                VirtualFile virtualFile = localVFCache.computeIfAbsent(path, it -> ExternalSystemUtil.findLocalFileByPath((String)it));
                ContainerUtil.addIfNotNull(projectBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
            }
            for (ExternalModuleBuildClasspathPojo moduleBuildClasspathPojo : projectBuildClasspathPojo.getModulesBuildClasspath().values()) {
                ArrayList moduleBuildClasspath = new ArrayList(projectBuildClasspath);
                for (String path : moduleBuildClasspathPojo.getEntries()) {
                    VirtualFile virtualFile = localVFCache.computeIfAbsent(path, it -> ExternalSystemUtil.findLocalFileByPath((String)it));
                    ContainerUtil.addIfNotNull(moduleBuildClasspath, (Object)(virtualFile == null || virtualFile.isDirectory() ? virtualFile : jarFileSystem.getJarRootForLocalFile(virtualFile)));
                }
                map.put(moduleBuildClasspathPojo.getPath(), moduleBuildClasspath);
            }
        }
        this.myClasspathMap.set(map);
        LinkedHashSet<VirtualFile> set = new LinkedHashSet<VirtualFile>();
        for (List<VirtualFile> virtualFiles : this.myClasspathMap.get().values()) {
            set.addAll(virtualFiles);
        }
        this.allFilesCache = new ArrayList<VirtualFile>(set);
        this.myClassFinderCache.clear();
    }

    @NotNull
    public Map<String, PackageDirectoryCache> getClassFinderCache() {
        return this.myClassFinderCache;
    }

    @NotNull
    public List<VirtualFile> getAllClasspathEntries() {
        this.checkRootsValidity(this.allFilesCache);
        if (this.allFilesCache == null) {
            this.reload();
        }
        return Objects.requireNonNull(this.allFilesCache);
    }

    @NotNull
    public List<VirtualFile> getModuleClasspathEntries(@NotNull String externalModulePath) {
        this.checkRootsValidity(this.myClasspathMap.get().get(externalModulePath));
        List<VirtualFile> virtualFiles = this.myClasspathMap.get().get(externalModulePath);
        return virtualFiles == null ? Collections.emptyList() : virtualFiles;
    }

    private void checkRootsValidity(@Nullable List<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            return;
        }
        if (!virtualFiles.isEmpty()) {
            for (VirtualFile file : virtualFiles) {
                if (file.isValid()) continue;
                this.reload();
                break;
            }
        }
    }
}

