/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class AnnotationProcessingData {
    public static final Key<AnnotationProcessingData> KEY = Key.create(AnnotationProcessingData.class, (int)1000);
    public static final Key<AnnotationProcessorOutput> OUTPUT_KEY = Key.create(AnnotationProcessorOutput.class, (int)1000);
    private static final Interner<AnnotationProcessingData> ourInterner = Interner.createWeakInterner();
    private final Collection<String> path;
    private final Collection<String> arguments;

    public static AnnotationProcessingData create(@NotNull Collection<String> path, @NotNull Collection<String> arguments) {
        return (AnnotationProcessingData)ourInterner.intern((Object)new AnnotationProcessingData(path, arguments));
    }

    @PropertyMapping(value={"path", "arguments"})
    private AnnotationProcessingData(@NotNull Collection<String> path, @NotNull Collection<String> arguments) {
        this.path = ContainerUtil.immutableList(new ArrayList<String>(path));
        this.arguments = ContainerUtil.immutableList(new ArrayList<String>(arguments));
    }

    public Collection<String> getArguments() {
        return this.arguments;
    }

    public Collection<String> getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationProcessingData data = (AnnotationProcessingData)o;
        if (!this.path.equals(data.path)) {
            return false;
        }
        return this.arguments.equals(data.arguments);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public static class AnnotationProcessorOutput {
        private final String outputPath;
        private final boolean testSources;

        @PropertyMapping(value={"outputPath", "testSources"})
        public AnnotationProcessorOutput(@NotNull String path, boolean isTestSources) {
            this.outputPath = path;
            this.testSources = isTestSources;
        }

        @NotNull
        public String getOutputPath() {
            return this.outputPath;
        }

        public boolean isTestSources() {
            return this.testSources;
        }
    }
}

