/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeTestEvent
extends AbstractTestEvent {
    public BeforeTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String displayName = eventXml.getTestDisplayName();
        String fqClassName = eventXml.getTestClassName();
        this.doProcess(testId, parentTestId, name, displayName, fqClassName);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String parentTestId = testEvent.getParentEventId();
        String fqClassName = testDescriptor.getClassName();
        this.doProcess(testId, parentTestId, testDescriptor.getMethodName(), testDescriptor.getDisplayName(), fqClassName);
    }

    private void doProcess(String testId, String parentTestId, String name, String displayName, String fqClassName) {
        String locationUrl = this.computeLocationUrl(this.findTestProxy(parentTestId), fqClassName, name, displayName);
        GradleSMTestProxy testProxy = new GradleSMTestProxy(displayName, false, locationUrl, fqClassName);
        testProxy.setStarted();
        testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
        this.registerTestProxy(testId, testProxy);
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.getResultsViewer().getTestsRootNode().addChild((SMTestProxy)testProxy);
        } else {
            SMTestProxy parentTestProxy = this.findTestProxy(parentTestId);
            if (parentTestProxy != null) {
                SmartList notYetAddedParents = new SmartList();
                SMTestProxy currentParentTestProxy = parentTestProxy;
                while (currentParentTestProxy instanceof GradleSMTestProxy) {
                    String parentId = ((GradleSMTestProxy)currentParentTestProxy).getParentId();
                    if (currentParentTestProxy.getParent() == null && parentId != null) {
                        notYetAddedParents.add((GradleSMTestProxy)currentParentTestProxy);
                    }
                    currentParentTestProxy = this.findTestProxy(parentId);
                }
                for (GradleSMTestProxy gradleSMTestProxy : ContainerUtil.reverse((List)notYetAddedParents)) {
                    SMTestProxy parentTestProxy1 = this.findTestProxy(gradleSMTestProxy.getParentId());
                    if (parentTestProxy1 == null) continue;
                    parentTestProxy1.addChild((SMTestProxy)gradleSMTestProxy);
                    this.getResultsViewer().onSuiteStarted((SMTestProxy)gradleSMTestProxy);
                    this.getExecutionConsole().getEventPublisher().onSuiteStarted((SMTestProxy)gradleSMTestProxy);
                }
                parentTestProxy.addChild((SMTestProxy)testProxy);
            }
        }
        this.getResultsViewer().onTestStarted((SMTestProxy)testProxy);
        this.getExecutionConsole().getEventPublisher().onTestStarted((SMTestProxy)testProxy);
    }
}

