/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterSuiteEvent
extends AbstractTestEvent {
    public AfterSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (!(testEvent instanceof ExternalSystemFinishEvent)) {
            return;
        }
        String testId = testEvent.getEventId();
        TestEventResult result = TestEventResult.fromOperationResult(((ExternalSystemFinishEvent)testEvent).getOperationResult());
        this.doProcess(testId, result);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        this.doProcess(testId, result);
    }

    private void doProcess(String testId, TestEventResult result) {
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        if (testProxy != this.getResultsViewer().getTestsRootNode()) {
            if (testProxy instanceof GradleSMTestProxy) {
                TestEventResult lastResult = ((GradleSMTestProxy)testProxy).getLastResult();
                if (lastResult == TestEventResult.FAILURE) {
                    result = TestEventResult.FAILURE;
                }
                ((GradleSMTestProxy)testProxy).setLastResult(result);
            }
            switch (result) {
                case SUCCESS: {
                    testProxy.setFinished();
                    break;
                }
                case FAILURE: {
                    testProxy.setTestFailed("", null, false);
                    break;
                }
                case SKIPPED: {
                    testProxy.setTestIgnored(null, null);
                    break;
                }
            }
            this.getResultsViewer().onSuiteFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onSuiteFinished(testProxy);
        }
    }

    @Override
    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return AfterSuiteEvent.findLocationUrl("java:suite", name, fqClassName);
    }
}

