/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.util.config.AbstractProperty;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestLocationCustomizer;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEvent(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myExecutionConsole.getResultsViewer();
    }

    protected Project getProject() {
        return this.myExecutionConsole.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return AbstractTestEvent.findLocationUrl("java:test", name, fqClassName);
    }

    @NotNull
    protected static String findLocationUrl(@NotNull String protocol, @Nullable String name, @NotNull String fqClassName) {
        return name == null ? JavaTestLocator.createLocationUrl((String)protocol, (String)fqClassName) : JavaTestLocator.createLocationUrl((String)protocol, (String)fqClassName, (String)name);
    }

    @Nullable
    protected SMTestProxy findTestProxy(String proxyId) {
        return this.getExecutionConsole().getTestsMap().get(proxyId);
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.myExecutionConsole.getTestsMap().put(proxyId, testProxy);
    }

    protected String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    protected boolean showInternalTestNodes() {
        return GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties());
    }

    @NotNull
    protected final String computeLocationUrl(@Nullable SMTestProxy parentProxy, @NotNull String fqClassName, @Nullable String name, @Nullable String displayName) {
        if (parentProxy != null) {
            for (GradleTestLocationCustomizer customizer : GradleTestLocationCustomizer.EP_NAME.getExtensionList()) {
                GradleTestLocationCustomizer.GradleTestLocationInfo location = customizer.getLocationInfo(this.getProject(), parentProxy, fqClassName, name, displayName);
                if (location == null) continue;
                return this.findLocationUrl(location.getMethodName(), location.getFqClassName());
            }
        }
        return this.findLocationUrl(name, fqClassName);
    }
}

