/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FileColorManager;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import icons.ExternalSystemIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.TasksToRun;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\"\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000f0\u000e0\rJP\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0015\u0012\u0004\u0012\u0002H\u00130\u000f2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000e\u0012\u0004\u0012\u00020\u00040\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J>\u0010\u001a\u001a\"\u0012\b\u0012\u00060\u0010j\u0002`\u0015\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000f0\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014JP\u0010\u001e\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0015\u0012\u0004\u0012\u0002H\u00130\u000f2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000e\u0012\u0004\u0012\u00020\u00040\u0016H\u0014J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser;", "", "()V", "chooseTestTasks", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "consumer", "Ljava/util/function/Consumer;", "", "", "", "Lorg/jetbrains/plugins/gradle/execution/test/runner/SourcePath;", "Lorg/jetbrains/plugins/gradle/util/TasksToRun;", "T", "testTasks", "Lorg/jetbrains/plugins/gradle/execution/test/runner/TestName;", "Lkotlin/Function1;", "error", "", "message", "findAllTestsTaskToRun", "sources", "Lcom/intellij/openapi/vfs/VirtualFile;", "showTestTasksNotFoundWarning", "showTestTasksPopupChooser", "suggestPopupTitle", "Companion", "TestTaskListCellRenderer", "intellij.gradle.java"})
public class TestTasksChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = Logger.getInstance(TestTasksChooser.class);
    @NotNull
    private static final String TEST_TASK_NAME = "test";
    @JvmField
    @NotNull
    public static final DataKey<String> LOCATION = DataKey.create((String)"org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser.LOCATION");

    private final Void error(String message) {
        LOG.error(message);
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Iterable<? extends PsiElement> elements, @NotNull Consumer<List<Map<String, TasksToRun>>> consumer) {
        void $this$mapTo$iv$iv;
        Iterable<? extends PsiElement> $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable<? extends PsiElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = TestGradleConfigurationProducerUtilKt.getSourceFile((PsiElement)it);
            if (virtualFile == null) {
                this.error("Can not find source file for " + (PsiElement)it);
                throw new KotlinNothingValueException();
            }
            collection.add(virtualFile);
        }
        List sources = (List)destination$iv$iv;
        Map<String, Map<String, TasksToRun>> testTasks = this.findAllTestsTaskToRun(sources, project);
        this.chooseTestTasks(project, context, testTasks, (Function1)new Function1<List<? extends Map<String, ? extends TasksToRun>>, Unit>(consumer){

            public final void invoke(@NotNull List<? extends Map<String, ? extends TasksToRun>> p0) {
                ((Consumer)this.receiver).accept(p0);
            }
        });
    }

    public <T> void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        if (testTasks.isEmpty()) {
            this.showTestTasksNotFoundWarning(project, context);
        } else if (testTasks.size() == 1) {
            consumer.invoke((Object)CollectionsKt.toList((Iterable)testTasks.values()));
        } else {
            this.showTestTasksPopupChooser(project, context, testTasks, consumer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, TasksToRun>> findAllTestsTaskToRun(List<? extends VirtualFile> sources, Project project) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Map testTasks;
        Object element$iv$iv3;
        Map $this$associateTo$iv$iv;
        Iterable $this$associate$iv = sources;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator<Object> iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            element$iv$iv3 = iterator.next();
            Map map = destination$iv$iv;
            VirtualFile source = (VirtualFile)element$iv$iv3;
            boolean bl = false;
            Iterable iterable2 = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
            String string = source.getPath();
            boolean $i$f$associateBy = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var19_22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                TasksToRun tasksToRun = (TasksToRun)element$iv$iv2;
                Map map2 = destination$iv$iv2;
                boolean bl2 = false;
                map2.put(it.getTestName(), element$iv$iv2);
            }
            source = TuplesKt.to((Object)string, (Object)destination$iv$iv2);
            map.put(source.getFirst(), source.getSecond());
        }
        Map $this$flatMap$iv = testTasks = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$associateTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv$iv3 = (Map.Entry)iterator.next();
            boolean bl = false;
            list$iv$iv = ((Map)it.getValue()).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set testTaskNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = testTaskNames;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void name;
            list$iv$iv = (String)element$iv$iv3;
            Object object = element$iv$iv3;
            Map map = result$iv;
            boolean bl = false;
            Map map3 = TestTasksChooser.Companion.mapNotNullValues(testTasks, (Function1)new Function1<Map.Entry<? extends String, ? extends Map<String, ? extends TasksToRun>>, TasksToRun>((String)name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @Nullable
                public final TasksToRun invoke(@NotNull Map.Entry<String, ? extends Map<String, ? extends TasksToRun>> it) {
                    return it.getValue().get(this.$name);
                }
            });
            map.put(object, map3);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    protected <T> void showTestTasksPopupChooser(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        void $this$sortedByDescending$iv;
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isCommandLine();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable iterable = CollectionsKt.toList((Iterable)testTasks.keySet());
        boolean $i$f$sortedByDescending = false;
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test"));
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test")));
            }
        })).setRenderer((ListCellRenderer)new TestTaskListCellRenderer(project)).setTitle(this.suggestPopupTitle(context)).setAutoselectOnMouseMove(false).setNamerForFiltering(FunctionUtil.id()).setMovable(true).setAdText(GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.hint", (Object[])new Object[0])).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemsChosenCallback(arg_0 -> TestTasksChooser.showTestTasksPopupChooser$lambda$6((Function1)new Function1<Set<? extends String>, Unit>(testTasks, this, project, context, consumer){
            final /* synthetic */ Map<String, T> $testTasks;
            final /* synthetic */ TestTasksChooser this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ DataContext $context;
            final /* synthetic */ Function1<List<? extends T>, Unit> $consumer;
            {
                this.$testTasks = $testTasks;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$context = $context;
                this.$consumer = $consumer;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Set<? extends String> it) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = it;
                Map<String, T> map = this.$testTasks;
                boolean $i$f$mapNotNull = false;
                void var6_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    T it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String p0 = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (map.get(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List choosesTestTasks = (List)destination$iv$iv;
                if (choosesTestTasks.isEmpty()) {
                    this.this$0.showTestTasksNotFoundWarning(this.$project, this.$context);
                } else {
                    this.$consumer.invoke((Object)choosesTestTasks);
                }
            }
        }, arg_0)).createPopup().show(PopupUtilsKt.getBestPopupPosition((DataContext)context));
    }

    protected void showTestTasksNotFoundWarning(@NotNull Project project, @NotNull DataContext context) {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isCommandLine();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GradleBundle.message((String)"gradle.tests.tasks.choosing.warning.text", (Object[])new Object[0]))).setFillColor(IdeTooltipManager.getInstance().getTextBackground(false)).createBalloon().show(PopupUtilsKt.getBestBalloonPosition((DataContext)context), Balloon.Position.above);
    }

    @NlsContexts.PopupTitle
    private final String suggestPopupTitle(DataContext context) {
        String string;
        String locationName = (String)context.getData(LOCATION);
        if (locationName == null) {
            string = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title.common", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{locationName};
            string = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title", (Object[])objectArray);
        }
        return string;
    }

    private static final void showTestTasksPopupChooser$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
        return Companion.contextWithLocationName(context, locationName);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskListCellRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cellInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "colorManager", "Lcom/intellij/ui/FileColorManager;", "kotlin.jvm.PlatformType", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "", "index", "", "isSelected", "", "cellHasFocus", "intellij.gradle.java"})
    private static final class TestTaskListCellRenderer
    extends DefaultListCellRenderer {
        @NotNull
        private final JBInsets cellInsets = JBUI.insets((int)1, (int)5);
        private final FileColorManager colorManager;

        public TestTaskListCellRenderer(@NotNull Project project) {
            this.colorManager = FileColorManager.getInstance((Project)project);
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(String.valueOf(value));
            this.setIcon(ExternalSystemIcons.Task);
            this.setIconTextGap(this.cellInsets.left);
            this.setBorder(new EmptyBorder((Insets)this.cellInsets));
            if (!isSelected) {
                this.setBackground(this.colorManager.getScopeColor("Tests"));
            }
            return this;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0007JX\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0013\"\u0004\b\u0002\u0010\u0012*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u00102 \u0010\u0014\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0015H\u0002R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion;", "", "()V", "LOCATION", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TEST_TASK_NAME", "contextWithLocationName", "Lcom/intellij/openapi/actionSystem/DataContext;", "context", "locationName", "mapNotNullValues", "", "K", "R", "V", "transform", "Lkotlin/Function1;", "", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
            if (locationName == null) {
                return context;
            }
            return arg_0 -> Companion.contextWithLocationName$lambda$0(locationName, context, arg_0);
        }

        /*
         * WARNING - void declaration
         */
        private final <K, V, R> Map<K, R> mapNotNullValues(Map<K, ? extends V> $this$mapNotNullValues, Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
            void $this$mapNotNullTo$iv$iv;
            Map<K, ? extends V> $this$mapNotNull$iv = $this$mapNotNullValues;
            boolean $i$f$mapNotNull = false;
            Map<K, ? extends V> map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                if (transform.invoke(entry) != null) {
                    Object it;
                    boolean bl3 = false;
                    pair = TuplesKt.to(entry.getKey(), (Object)it);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private static final Object contextWithLocationName$lambda$0(String $locationName, DataContext $context, String it) {
            return LOCATION.is(it) ? $locationName : $context.getData(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

