/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;

public final class PatternGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    private final GradlePatternBasedConfigurationProducer<?> myBaseConfigurationProducer = new GradlePatternBasedConfigurationProducer();

    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return other.isProducedBy(TestClassGradleConfigurationProducer.class) || other.isProducedBy(TestMethodGradleConfigurationProducer.class) || super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return other.isProducedBy(TestClassGradleConfigurationProducer.class) || other.isProducedBy(TestMethodGradleConfigurationProducer.class) || super.shouldReplace(self, other);
    }

    @Override
    protected boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (!this.myBaseConfigurationProducer.isMultipleElementsSelected(context)) {
            return false;
        }
        ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
        if (!GradleConstants.SYSTEM_ID.equals((Object)settings.getExternalSystemId())) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Project project = context.getProject();
        List<String> tests = this.getTestPatterns(context);
        if (tests.isEmpty()) {
            return false;
        }
        TestMappings testMappings = PatternGradleConfigurationProducer.getTestMappings(project, tests);
        Function1 findTestSource2 = test -> TestGradleConfigurationProducerUtilKt.getSourceFile((PsiElement)testMappings.getClasses().get(test));
        Function1 createFilter = test -> GradleExecutionSettingsUtil.createTestFilterFrom(testMappings.getClasses().get(test), testMappings.getMethods().get(test));
        Module module = PatternGradleConfigurationProducer.getModuleFromContext(context);
        if (module == null) {
            return false;
        }
        if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, module, tests, findTestSource2, createFilter)) {
            return false;
        }
        configuration.setName(PatternGradleConfigurationProducer.suggestConfigurationName(tests));
        PatternGradleConfigurationProducer.setUniqueNameIfNeeded(project, configuration);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        return false;
    }

    @Override
    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (!this.myBaseConfigurationProducer.isMultipleElementsSelected(context)) {
            super.onFirstRun(configuration, context, startRunnable);
            return;
        }
        Module module = PatternGradleConfigurationProducer.getModuleFromContext(context);
        if (module == null) {
            LOG.warn("Cannot find module from context, uses raw run configuration");
            super.onFirstRun(configuration, context, startRunnable);
            return;
        }
        GradleRunConfiguration runConfiguration = (GradleRunConfiguration)configuration.getConfiguration();
        Project project = context.getProject();
        List<String> tests = this.getTestPatterns(context);
        if (tests.isEmpty()) {
            LOG.warn("Cannot find runnable tests from context, uses raw run configuration");
            super.onFirstRun(configuration, context, startRunnable);
            return;
        }
        TestMappings testMappings = PatternGradleConfigurationProducer.getTestMappings(project, tests);
        this.getTestTasksChooser().chooseTestTasks(project, context.getDataContext(), testMappings.getClasses().values(), tasks -> {
            Function1 createFilter;
            Function1 findTestSource2;
            ExternalSystemTaskExecutionSettings settings = runConfiguration.getSettings();
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration(settings, module, tasks, tests, findTestSource2 = test -> TestGradleConfigurationProducerUtilKt.getSourceFile((PsiElement)testMappings.getClasses().get(test)), createFilter = test -> GradleExecutionSettingsUtil.createTestFilterFrom(testMappings.getClasses().get(test), testMappings.getMethods().get(test)))) {
                LOG.warn("Cannot apply pattern test configuration, uses raw run configuration");
                super.onFirstRun(configuration, context, startRunnable);
                return;
            }
            runConfiguration.setName(PatternGradleConfigurationProducer.suggestConfigurationName(tests));
            PatternGradleConfigurationProducer.setUniqueNameIfNeeded(project, runConfiguration);
            super.onFirstRun(configuration, context, startRunnable);
        });
    }

    @NotNull
    private static String suggestConfigurationName(List<String> tests) {
        if (tests.isEmpty()) {
            return "";
        }
        if (tests.size() == 1) {
            return tests.get(0);
        }
        return GradleBundle.message((String)"gradle.tests.pattern.producer.configuration.name", (Object[])new Object[]{tests.get(0), tests.size() - 1});
    }

    @Nullable
    private static Module getModuleFromContext(ConfigurationContext context) {
        Module module = context.getModule();
        if (module != null) {
            return module;
        }
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return null;
        }
        PsiElement locationElement = contextLocation.getPsiElement();
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)locationElement);
    }

    @NotNull
    private static TestMappings getTestMappings(@NotNull Project project, @NotNull List<String> tests) {
        LinkedHashMap<String, PsiClass> classes = new LinkedHashMap<String, PsiClass>();
        LinkedHashMap<String, String> methods = new LinkedHashMap<String, String>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        for (String test : tests) {
            int i = StringUtil.indexOf((CharSequence)test, (CharSequence)",");
            String className = i < 0 ? test : test.substring(0, i);
            PsiClass psiClass = psiFacade.findClass(className, projectScope);
            classes.put(test, psiClass);
            String method = i != -1 && test.length() > i + 1 ? test.substring(i + 1) : null;
            methods.put(test, method);
        }
        return new TestMappings(classes, methods);
    }

    private List<String> getTestPatterns(@NotNull ConfigurationContext context) {
        LinkedHashSet tests = new LinkedHashSet();
        this.myBaseConfigurationProducer.checkPatterns(context, tests);
        return new ArrayList<String>(tests);
    }

    private static class GradlePatternBasedConfigurationProducer<T extends JavaTestConfigurationBase>
    extends AbstractPatternBasedConfigurationProducer<T> {
        private GradlePatternBasedConfigurationProducer() {
        }

        @NotNull
        public ConfigurationFactory getConfigurationFactory() {
            return GradleExternalTaskConfigurationType.getInstance().getFactory();
        }

        protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
            return false;
        }

        public boolean isConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context) {
            return false;
        }

        public void collectTestMembers(PsiElement[] psiElements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> collectingProcessor) {
            PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
            super.collectTestMembers(psiElements, false, false, processor);
            for (PsiElement element : processor.getCollection()) {
                if (checkIsTest && !GradlePatternBasedConfigurationProducer.isTest(element, checkAbstract)) continue;
                collectingProcessor.execute(element);
            }
        }

        private static boolean isTest(PsiElement element, boolean checkAbstract) {
            return element instanceof PsiClass && GradlePatternBasedConfigurationProducer.isTestClass((PsiClass)element, checkAbstract) || element instanceof PsiMethod && GradlePatternBasedConfigurationProducer.isTestMethod((PsiMethod)element, checkAbstract);
        }

        private static boolean isTestMethod(PsiMethod psiMethod, boolean checkAbstract) {
            return TestFrameworks.getInstance().isTestMethod(psiMethod, checkAbstract);
        }

        private static boolean isTestClass(PsiClass psiMethod, boolean checkAbstract) {
            if (checkAbstract && psiMethod.hasModifierProperty("abstract")) {
                return false;
            }
            return TestFrameworks.getInstance().isTestClass(psiMethod);
        }
    }

    private static final class TestMappings {
        private final Map<String, PsiClass> classes;
        private final Map<String, String> methods;

        private TestMappings(Map<String, PsiClass> classes, Map<String, String> methods) {
            this.classes = classes;
            this.methods = methods;
        }

        private Map<String, PsiClass> getClasses() {
            return this.classes;
        }

        private Map<String, String> getMethods() {
            return this.methods;
        }
    }
}

